/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSnowballUsageResponse extends SnowballResponse implements
        ToCopyableBuilder<GetSnowballUsageResponse.Builder, GetSnowballUsageResponse> {
    private static final SdkField<Integer> SNOWBALL_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnowballLimit").getter(getter(GetSnowballUsageResponse::snowballLimit))
            .setter(setter(Builder::snowballLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballLimit").build()).build();

    private static final SdkField<Integer> SNOWBALLS_IN_USE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnowballsInUse").getter(getter(GetSnowballUsageResponse::snowballsInUse))
            .setter(setter(Builder::snowballsInUse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballsInUse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNOWBALL_LIMIT_FIELD,
            SNOWBALLS_IN_USE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer snowballLimit;

    private final Integer snowballsInUse;

    private GetSnowballUsageResponse(BuilderImpl builder) {
        super(builder);
        this.snowballLimit = builder.snowballLimit;
        this.snowballsInUse = builder.snowballsInUse;
    }

    /**
     * <p>
     * The service limit for number of Snow devices this account can have at once. The default service limit is 1 (one).
     * </p>
     * 
     * @return The service limit for number of Snow devices this account can have at once. The default service limit is
     *         1 (one).
     */
    public final Integer snowballLimit() {
        return snowballLimit;
    }

    /**
     * <p>
     * The number of Snow devices that this account is currently using.
     * </p>
     * 
     * @return The number of Snow devices that this account is currently using.
     */
    public final Integer snowballsInUse() {
        return snowballsInUse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snowballLimit());
        hashCode = 31 * hashCode + Objects.hashCode(snowballsInUse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSnowballUsageResponse)) {
            return false;
        }
        GetSnowballUsageResponse other = (GetSnowballUsageResponse) obj;
        return Objects.equals(snowballLimit(), other.snowballLimit()) && Objects.equals(snowballsInUse(), other.snowballsInUse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSnowballUsageResponse").add("SnowballLimit", snowballLimit())
                .add("SnowballsInUse", snowballsInUse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnowballLimit":
            return Optional.ofNullable(clazz.cast(snowballLimit()));
        case "SnowballsInUse":
            return Optional.ofNullable(clazz.cast(snowballsInUse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SnowballLimit", SNOWBALL_LIMIT_FIELD);
        map.put("SnowballsInUse", SNOWBALLS_IN_USE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSnowballUsageResponse, T> g) {
        return obj -> g.apply((GetSnowballUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSnowballUsageResponse> {
        /**
         * <p>
         * The service limit for number of Snow devices this account can have at once. The default service limit is 1
         * (one).
         * </p>
         * 
         * @param snowballLimit
         *        The service limit for number of Snow devices this account can have at once. The default service limit
         *        is 1 (one).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowballLimit(Integer snowballLimit);

        /**
         * <p>
         * The number of Snow devices that this account is currently using.
         * </p>
         * 
         * @param snowballsInUse
         *        The number of Snow devices that this account is currently using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowballsInUse(Integer snowballsInUse);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private Integer snowballLimit;

        private Integer snowballsInUse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSnowballUsageResponse model) {
            super(model);
            snowballLimit(model.snowballLimit);
            snowballsInUse(model.snowballsInUse);
        }

        public final Integer getSnowballLimit() {
            return snowballLimit;
        }

        public final void setSnowballLimit(Integer snowballLimit) {
            this.snowballLimit = snowballLimit;
        }

        @Override
        public final Builder snowballLimit(Integer snowballLimit) {
            this.snowballLimit = snowballLimit;
            return this;
        }

        public final Integer getSnowballsInUse() {
            return snowballsInUse;
        }

        public final void setSnowballsInUse(Integer snowballsInUse) {
            this.snowballsInUse = snowballsInUse;
        }

        @Override
        public final Builder snowballsInUse(Integer snowballsInUse) {
            this.snowballsInUse = snowballsInUse;
            return this;
        }

        @Override
        public GetSnowballUsageResponse build() {
            return new GetSnowballUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
