/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobResponse extends SnowballResponse implements
        ToCopyableBuilder<DescribeJobResponse.Builder, DescribeJobResponse> {
    private static final SdkField<JobMetadata> JOB_METADATA_FIELD = SdkField.<JobMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("JobMetadata").getter(getter(DescribeJobResponse::jobMetadata)).setter(setter(Builder::jobMetadata))
            .constructor(JobMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobMetadata").build()).build();

    private static final SdkField<List<JobMetadata>> SUB_JOB_METADATA_FIELD = SdkField
            .<List<JobMetadata>> builder(MarshallingType.LIST)
            .memberName("SubJobMetadata")
            .getter(getter(DescribeJobResponse::subJobMetadata))
            .setter(setter(Builder::subJobMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubJobMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_METADATA_FIELD,
            SUB_JOB_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final JobMetadata jobMetadata;

    private final List<JobMetadata> subJobMetadata;

    private DescribeJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobMetadata = builder.jobMetadata;
        this.subJobMetadata = builder.subJobMetadata;
    }

    /**
     * <p>
     * Information about a specific job, including shipping information, job status, and other important metadata.
     * </p>
     * 
     * @return Information about a specific job, including shipping information, job status, and other important
     *         metadata.
     */
    public final JobMetadata jobMetadata() {
        return jobMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubJobMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubJobMetadata() {
        return subJobMetadata != null && !(subJobMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about a specific job part (in the case of an export job), including shipping information, job status,
     * and other important metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubJobMetadata} method.
     * </p>
     * 
     * @return Information about a specific job part (in the case of an export job), including shipping information, job
     *         status, and other important metadata.
     */
    public final List<JobMetadata> subJobMetadata() {
        return subJobMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubJobMetadata() ? subJobMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobResponse)) {
            return false;
        }
        DescribeJobResponse other = (DescribeJobResponse) obj;
        return Objects.equals(jobMetadata(), other.jobMetadata()) && hasSubJobMetadata() == other.hasSubJobMetadata()
                && Objects.equals(subJobMetadata(), other.subJobMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeJobResponse").add("JobMetadata", jobMetadata())
                .add("SubJobMetadata", hasSubJobMetadata() ? subJobMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobMetadata":
            return Optional.ofNullable(clazz.cast(jobMetadata()));
        case "SubJobMetadata":
            return Optional.ofNullable(clazz.cast(subJobMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobMetadata", JOB_METADATA_FIELD);
        map.put("SubJobMetadata", SUB_JOB_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobResponse, T> g) {
        return obj -> g.apply((DescribeJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SnowballResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeJobResponse> {
        /**
         * <p>
         * Information about a specific job, including shipping information, job status, and other important metadata.
         * </p>
         * 
         * @param jobMetadata
         *        Information about a specific job, including shipping information, job status, and other important
         *        metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobMetadata(JobMetadata jobMetadata);

        /**
         * <p>
         * Information about a specific job, including shipping information, job status, and other important metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobMetadata.Builder} avoiding the need to
         * create one manually via {@link JobMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobMetadata.Builder#build()} is called immediately and its result
         * is passed to {@link #jobMetadata(JobMetadata)}.
         * 
         * @param jobMetadata
         *        a consumer that will call methods on {@link JobMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobMetadata(JobMetadata)
         */
        default Builder jobMetadata(Consumer<JobMetadata.Builder> jobMetadata) {
            return jobMetadata(JobMetadata.builder().applyMutation(jobMetadata).build());
        }

        /**
         * <p>
         * Information about a specific job part (in the case of an export job), including shipping information, job
         * status, and other important metadata.
         * </p>
         * 
         * @param subJobMetadata
         *        Information about a specific job part (in the case of an export job), including shipping information,
         *        job status, and other important metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subJobMetadata(Collection<JobMetadata> subJobMetadata);

        /**
         * <p>
         * Information about a specific job part (in the case of an export job), including shipping information, job
         * status, and other important metadata.
         * </p>
         * 
         * @param subJobMetadata
         *        Information about a specific job part (in the case of an export job), including shipping information,
         *        job status, and other important metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subJobMetadata(JobMetadata... subJobMetadata);

        /**
         * <p>
         * Information about a specific job part (in the case of an export job), including shipping information, job
         * status, and other important metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.snowball.model.JobMetadata.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.snowball.model.JobMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.snowball.model.JobMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #subJobMetadata(List<JobMetadata>)}.
         * 
         * @param subJobMetadata
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.snowball.model.JobMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subJobMetadata(java.util.Collection<JobMetadata>)
         */
        Builder subJobMetadata(Consumer<JobMetadata.Builder>... subJobMetadata);
    }

    static final class BuilderImpl extends SnowballResponse.BuilderImpl implements Builder {
        private JobMetadata jobMetadata;

        private List<JobMetadata> subJobMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobResponse model) {
            super(model);
            jobMetadata(model.jobMetadata);
            subJobMetadata(model.subJobMetadata);
        }

        public final JobMetadata.Builder getJobMetadata() {
            return jobMetadata != null ? jobMetadata.toBuilder() : null;
        }

        public final void setJobMetadata(JobMetadata.BuilderImpl jobMetadata) {
            this.jobMetadata = jobMetadata != null ? jobMetadata.build() : null;
        }

        @Override
        public final Builder jobMetadata(JobMetadata jobMetadata) {
            this.jobMetadata = jobMetadata;
            return this;
        }

        public final List<JobMetadata.Builder> getSubJobMetadata() {
            List<JobMetadata.Builder> result = JobMetadataListCopier.copyToBuilder(this.subJobMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubJobMetadata(Collection<JobMetadata.BuilderImpl> subJobMetadata) {
            this.subJobMetadata = JobMetadataListCopier.copyFromBuilder(subJobMetadata);
        }

        @Override
        public final Builder subJobMetadata(Collection<JobMetadata> subJobMetadata) {
            this.subJobMetadata = JobMetadataListCopier.copy(subJobMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subJobMetadata(JobMetadata... subJobMetadata) {
            subJobMetadata(Arrays.asList(subJobMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subJobMetadata(Consumer<JobMetadata.Builder>... subJobMetadata) {
            subJobMetadata(Stream.of(subJobMetadata).map(c -> JobMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeJobResponse build() {
            return new DescribeJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
