/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a cluster's state, a cluster's ID, and other important information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterListEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterListEntry.Builder, ClusterListEntry> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(ClusterListEntry::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> CLUSTER_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterState").getter(getter(ClusterListEntry::clusterStateAsString))
            .setter(setter(Builder::clusterState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterState").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(ClusterListEntry::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ClusterListEntry::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            CLUSTER_STATE_FIELD, CREATION_DATE_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clusterId;

    private final String clusterState;

    private final Instant creationDate;

    private final String description;

    private ClusterListEntry(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.clusterState = builder.clusterState;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
    }

    /**
     * <p>
     * The 39-character ID for the cluster that you want to list, for example
     * <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
     * </p>
     * 
     * @return The 39-character ID for the cluster that you want to list, for example
     *         <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The current state of this cluster. For information about the state of a specific node, see
     * <a>JobListEntry$JobState</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterState} will
     * return {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterStateAsString}.
     * </p>
     * 
     * @return The current state of this cluster. For information about the state of a specific node, see
     *         <a>JobListEntry$JobState</a>.
     * @see ClusterState
     */
    public final ClusterState clusterState() {
        return ClusterState.fromValue(clusterState);
    }

    /**
     * <p>
     * The current state of this cluster. For information about the state of a specific node, see
     * <a>JobListEntry$JobState</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterState} will
     * return {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterStateAsString}.
     * </p>
     * 
     * @return The current state of this cluster. For information about the state of a specific node, see
     *         <a>JobListEntry$JobState</a>.
     * @see ClusterState
     */
    public final String clusterStateAsString() {
        return clusterState;
    }

    /**
     * <p>
     * The creation date for this cluster.
     * </p>
     * 
     * @return The creation date for this cluster.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * Defines an optional description of the cluster, for example <code>Environmental Data Cluster-01</code>.
     * </p>
     * 
     * @return Defines an optional description of the cluster, for example <code>Environmental Data Cluster-01</code>.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterListEntry)) {
            return false;
        }
        ClusterListEntry other = (ClusterListEntry) obj;
        return Objects.equals(clusterId(), other.clusterId())
                && Objects.equals(clusterStateAsString(), other.clusterStateAsString())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterListEntry").add("ClusterId", clusterId()).add("ClusterState", clusterStateAsString())
                .add("CreationDate", creationDate()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "ClusterState":
            return Optional.ofNullable(clazz.cast(clusterStateAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("ClusterState", CLUSTER_STATE_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterListEntry, T> g) {
        return obj -> g.apply((ClusterListEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterListEntry> {
        /**
         * <p>
         * The 39-character ID for the cluster that you want to list, for example
         * <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
         * </p>
         * 
         * @param clusterId
         *        The 39-character ID for the cluster that you want to list, for example
         *        <code>CID123e4567-e89b-12d3-a456-426655440000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The current state of this cluster. For information about the state of a specific node, see
         * <a>JobListEntry$JobState</a>.
         * </p>
         * 
         * @param clusterState
         *        The current state of this cluster. For information about the state of a specific node, see
         *        <a>JobListEntry$JobState</a>.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder clusterState(String clusterState);

        /**
         * <p>
         * The current state of this cluster. For information about the state of a specific node, see
         * <a>JobListEntry$JobState</a>.
         * </p>
         * 
         * @param clusterState
         *        The current state of this cluster. For information about the state of a specific node, see
         *        <a>JobListEntry$JobState</a>.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder clusterState(ClusterState clusterState);

        /**
         * <p>
         * The creation date for this cluster.
         * </p>
         * 
         * @param creationDate
         *        The creation date for this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * Defines an optional description of the cluster, for example <code>Environmental Data Cluster-01</code>.
         * </p>
         * 
         * @param description
         *        Defines an optional description of the cluster, for example <code>Environmental Data Cluster-01</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String clusterId;

        private String clusterState;

        private Instant creationDate;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterListEntry model) {
            clusterId(model.clusterId);
            clusterState(model.clusterState);
            creationDate(model.creationDate);
            description(model.description);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getClusterState() {
            return clusterState;
        }

        public final void setClusterState(String clusterState) {
            this.clusterState = clusterState;
        }

        @Override
        public final Builder clusterState(String clusterState) {
            this.clusterState = clusterState;
            return this;
        }

        @Override
        public final Builder clusterState(ClusterState clusterState) {
            this.clusterState(clusterState == null ? null : clusterState.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public ClusterListEntry build() {
            return new ClusterListEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
