/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.JobState;
import software.amazon.awssdk.services.snowball.model.JobStateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Notification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Notification> {
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicARN").getter(Notification.getter(Notification::snsTopicARN)).setter(Notification.setter(Builder::snsTopicARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicARN").build()}).build();
    private static final SdkField<List<String>> JOB_STATES_TO_NOTIFY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobStatesToNotify").getter(Notification.getter(Notification::jobStatesToNotifyAsStrings)).setter(Notification.setter(Builder::jobStatesToNotifyWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatesToNotify").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEVICE_PICKUP_SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DevicePickupSnsTopicARN").getter(Notification.getter(Notification::devicePickupSnsTopicARN)).setter(Notification.setter(Builder::devicePickupSnsTopicARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevicePickupSnsTopicARN").build()}).build();
    private static final SdkField<Boolean> NOTIFY_ALL_JOB_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NotifyAllJobStates").getter(Notification.getter(Notification::notifyAllJobStates)).setter(Notification.setter(Builder::notifyAllJobStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotifyAll").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_TOPIC_ARN_FIELD, JOB_STATES_TO_NOTIFY_FIELD, DEVICE_PICKUP_SNS_TOPIC_ARN_FIELD, NOTIFY_ALL_JOB_STATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Notification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String snsTopicARN;
    private final List<String> jobStatesToNotify;
    private final String devicePickupSnsTopicARN;
    private final Boolean notifyAllJobStates;

    private Notification(BuilderImpl builder) {
        this.snsTopicARN = builder.snsTopicARN;
        this.jobStatesToNotify = builder.jobStatesToNotify;
        this.devicePickupSnsTopicARN = builder.devicePickupSnsTopicARN;
        this.notifyAllJobStates = builder.notifyAllJobStates;
    }

    public final String snsTopicARN() {
        return this.snsTopicARN;
    }

    public final List<JobState> jobStatesToNotify() {
        return JobStateListCopier.copyStringToEnum(this.jobStatesToNotify);
    }

    public final boolean hasJobStatesToNotify() {
        return this.jobStatesToNotify != null && !(this.jobStatesToNotify instanceof SdkAutoConstructList);
    }

    public final List<String> jobStatesToNotifyAsStrings() {
        return this.jobStatesToNotify;
    }

    public final String devicePickupSnsTopicARN() {
        return this.devicePickupSnsTopicARN;
    }

    public final Boolean notifyAllJobStates() {
        return this.notifyAllJobStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobStatesToNotify() ? this.jobStatesToNotifyAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.devicePickupSnsTopicARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.notifyAllJobStates());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)obj;
        return Objects.equals(this.snsTopicARN(), other.snsTopicARN()) && this.hasJobStatesToNotify() == other.hasJobStatesToNotify() && Objects.equals(this.jobStatesToNotifyAsStrings(), other.jobStatesToNotifyAsStrings()) && Objects.equals(this.devicePickupSnsTopicARN(), other.devicePickupSnsTopicARN()) && Objects.equals(this.notifyAllJobStates(), other.notifyAllJobStates());
    }

    public final String toString() {
        return ToString.builder((String)"Notification").add("SnsTopicARN", (Object)this.snsTopicARN()).add("JobStatesToNotify", this.hasJobStatesToNotify() ? this.jobStatesToNotifyAsStrings() : null).add("DevicePickupSnsTopicARN", (Object)this.devicePickupSnsTopicARN()).add("NotifyAllJobStates", (Object)this.notifyAllJobStates()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnsTopicARN": {
                return Optional.ofNullable(clazz.cast(this.snsTopicARN()));
            }
            case "JobStatesToNotify": {
                return Optional.ofNullable(clazz.cast(this.jobStatesToNotifyAsStrings()));
            }
            case "DevicePickupSnsTopicARN": {
                return Optional.ofNullable(clazz.cast(this.devicePickupSnsTopicARN()));
            }
            case "NotifyAllJobStates": {
                return Optional.ofNullable(clazz.cast(this.notifyAllJobStates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SnsTopicARN", SNS_TOPIC_ARN_FIELD);
        map.put("JobStatesToNotify", JOB_STATES_TO_NOTIFY_FIELD);
        map.put("DevicePickupSnsTopicARN", DEVICE_PICKUP_SNS_TOPIC_ARN_FIELD);
        map.put("NotifyAll", NOTIFY_ALL_JOB_STATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Notification, T> g) {
        return obj -> g.apply((Notification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snsTopicARN;
        private List<String> jobStatesToNotify = DefaultSdkAutoConstructList.getInstance();
        private String devicePickupSnsTopicARN;
        private Boolean notifyAllJobStates;

        private BuilderImpl() {
        }

        private BuilderImpl(Notification model) {
            this.snsTopicARN(model.snsTopicARN);
            this.jobStatesToNotifyWithStrings(model.jobStatesToNotify);
            this.devicePickupSnsTopicARN(model.devicePickupSnsTopicARN);
            this.notifyAllJobStates(model.notifyAllJobStates);
        }

        public final String getSnsTopicARN() {
            return this.snsTopicARN;
        }

        public final void setSnsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
        }

        @Override
        public final Builder snsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
            return this;
        }

        public final Collection<String> getJobStatesToNotify() {
            if (this.jobStatesToNotify instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobStatesToNotify;
        }

        public final void setJobStatesToNotify(Collection<String> jobStatesToNotify) {
            this.jobStatesToNotify = JobStateListCopier.copy(jobStatesToNotify);
        }

        @Override
        public final Builder jobStatesToNotifyWithStrings(Collection<String> jobStatesToNotify) {
            this.jobStatesToNotify = JobStateListCopier.copy(jobStatesToNotify);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobStatesToNotifyWithStrings(String ... jobStatesToNotify) {
            this.jobStatesToNotifyWithStrings(Arrays.asList(jobStatesToNotify));
            return this;
        }

        @Override
        public final Builder jobStatesToNotify(Collection<JobState> jobStatesToNotify) {
            this.jobStatesToNotify = JobStateListCopier.copyEnumToString(jobStatesToNotify);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobStatesToNotify(JobState ... jobStatesToNotify) {
            this.jobStatesToNotify(Arrays.asList(jobStatesToNotify));
            return this;
        }

        public final String getDevicePickupSnsTopicARN() {
            return this.devicePickupSnsTopicARN;
        }

        public final void setDevicePickupSnsTopicARN(String devicePickupSnsTopicARN) {
            this.devicePickupSnsTopicARN = devicePickupSnsTopicARN;
        }

        @Override
        public final Builder devicePickupSnsTopicARN(String devicePickupSnsTopicARN) {
            this.devicePickupSnsTopicARN = devicePickupSnsTopicARN;
            return this;
        }

        public final Boolean getNotifyAllJobStates() {
            return this.notifyAllJobStates;
        }

        public final void setNotifyAllJobStates(Boolean notifyAllJobStates) {
            this.notifyAllJobStates = notifyAllJobStates;
        }

        @Override
        public final Builder notifyAllJobStates(Boolean notifyAllJobStates) {
            this.notifyAllJobStates = notifyAllJobStates;
            return this;
        }

        public Notification build() {
            return new Notification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Notification> {
        public Builder snsTopicARN(String var1);

        public Builder jobStatesToNotifyWithStrings(Collection<String> var1);

        public Builder jobStatesToNotifyWithStrings(String ... var1);

        public Builder jobStatesToNotify(Collection<JobState> var1);

        public Builder jobStatesToNotify(JobState ... var1);

        public Builder devicePickupSnsTopicARN(String var1);

        public Builder notifyAllJobStates(Boolean var1);
    }
}

