/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.ClusterState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterListEntry> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(ClusterListEntry.getter(ClusterListEntry::clusterId)).setter(ClusterListEntry.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> CLUSTER_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterState").getter(ClusterListEntry.getter(ClusterListEntry::clusterStateAsString)).setter(ClusterListEntry.setter(Builder::clusterState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterState").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(ClusterListEntry.getter(ClusterListEntry::creationDate)).setter(ClusterListEntry.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ClusterListEntry.getter(ClusterListEntry::description)).setter(ClusterListEntry.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, CLUSTER_STATE_FIELD, CREATION_DATE_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterListEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterId;
    private final String clusterState;
    private final Instant creationDate;
    private final String description;

    private ClusterListEntry(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.clusterState = builder.clusterState;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final ClusterState clusterState() {
        return ClusterState.fromValue(this.clusterState);
    }

    public final String clusterStateAsString() {
        return this.clusterState;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterListEntry)) {
            return false;
        }
        ClusterListEntry other = (ClusterListEntry)obj;
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.clusterStateAsString(), other.clusterStateAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterListEntry").add("ClusterId", (Object)this.clusterId()).add("ClusterState", (Object)this.clusterStateAsString()).add("CreationDate", (Object)this.creationDate()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "ClusterState": {
                return Optional.ofNullable(clazz.cast(this.clusterStateAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("ClusterState", CLUSTER_STATE_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterListEntry, T> g) {
        return obj -> g.apply((ClusterListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterId;
        private String clusterState;
        private Instant creationDate;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterListEntry model) {
            this.clusterId(model.clusterId);
            this.clusterState(model.clusterState);
            this.creationDate(model.creationDate);
            this.description(model.description);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getClusterState() {
            return this.clusterState;
        }

        public final void setClusterState(String clusterState) {
            this.clusterState = clusterState;
        }

        @Override
        public final Builder clusterState(String clusterState) {
            this.clusterState = clusterState;
            return this;
        }

        @Override
        public final Builder clusterState(ClusterState clusterState) {
            this.clusterState(clusterState == null ? null : clusterState.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public ClusterListEntry build() {
            return new ClusterListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterListEntry> {
        public Builder clusterId(String var1);

        public Builder clusterState(String var1);

        public Builder clusterState(ClusterState var1);

        public Builder creationDate(Instant var1);

        public Builder description(String var1);
    }
}

