/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.DependentService;
import software.amazon.awssdk.services.snowball.model.DependentServiceListCopier;
import software.amazon.awssdk.services.snowball.model.ServiceName;
import software.amazon.awssdk.services.snowball.model.SnowballRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceVersionsRequest
extends SnowballRequest
implements ToCopyableBuilder<Builder, ListServiceVersionsRequest> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(ListServiceVersionsRequest.getter(ListServiceVersionsRequest::serviceNameAsString)).setter(ListServiceVersionsRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<List<DependentService>> DEPENDENT_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DependentServices").getter(ListServiceVersionsRequest.getter(ListServiceVersionsRequest::dependentServices)).setter(ListServiceVersionsRequest.setter(Builder::dependentServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependentServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DependentService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListServiceVersionsRequest.getter(ListServiceVersionsRequest::maxResults)).setter(ListServiceVersionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServiceVersionsRequest.getter(ListServiceVersionsRequest::nextToken)).setter(ListServiceVersionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, DEPENDENT_SERVICES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ServiceName", SERVICE_NAME_FIELD);
            this.put("DependentServices", DEPENDENT_SERVICES_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String serviceName;
    private final List<DependentService> dependentServices;
    private final Integer maxResults;
    private final String nextToken;

    private ListServiceVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceName = builder.serviceName;
        this.dependentServices = builder.dependentServices;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final ServiceName serviceName() {
        return ServiceName.fromValue(this.serviceName);
    }

    public final String serviceNameAsString() {
        return this.serviceName;
    }

    public final boolean hasDependentServices() {
        return this.dependentServices != null && !(this.dependentServices instanceof SdkAutoConstructList);
    }

    public final List<DependentService> dependentServices() {
        return this.dependentServices;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependentServices() ? this.dependentServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceVersionsRequest)) {
            return false;
        }
        ListServiceVersionsRequest other = (ListServiceVersionsRequest)((Object)obj);
        return Objects.equals(this.serviceNameAsString(), other.serviceNameAsString()) && this.hasDependentServices() == other.hasDependentServices() && Objects.equals(this.dependentServices(), other.dependentServices()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceVersionsRequest").add("ServiceName", (Object)this.serviceNameAsString()).add("DependentServices", this.hasDependentServices() ? this.dependentServices() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceNameAsString()));
            }
            case "DependentServices": {
                return Optional.ofNullable(clazz.cast(this.dependentServices()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceVersionsRequest, T> g) {
        return obj -> g.apply((ListServiceVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballRequest.BuilderImpl
    implements Builder {
        private String serviceName;
        private List<DependentService> dependentServices = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceVersionsRequest model) {
            super(model);
            this.serviceName(model.serviceName);
            this.dependentServices(model.dependentServices);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final Builder serviceName(ServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        public final List<DependentService.Builder> getDependentServices() {
            List<DependentService.Builder> result = DependentServiceListCopier.copyToBuilder(this.dependentServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependentServices(Collection<DependentService.BuilderImpl> dependentServices) {
            this.dependentServices = DependentServiceListCopier.copyFromBuilder(dependentServices);
        }

        @Override
        public final Builder dependentServices(Collection<DependentService> dependentServices) {
            this.dependentServices = DependentServiceListCopier.copy(dependentServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependentServices(DependentService ... dependentServices) {
            this.dependentServices(Arrays.asList(dependentServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependentServices(Consumer<DependentService.Builder> ... dependentServices) {
            this.dependentServices(Stream.of(dependentServices).map(c -> (DependentService)((DependentService.Builder)DependentService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceVersionsRequest build() {
            return new ListServiceVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SnowballRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceVersionsRequest> {
        public Builder serviceName(String var1);

        public Builder serviceName(ServiceName var1);

        public Builder dependentServices(Collection<DependentService> var1);

        public Builder dependentServices(DependentService ... var1);

        public Builder dependentServices(Consumer<DependentService.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

