/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceServiceName {
    NFS_ON_DEVICE_SERVICE("NFS_ON_DEVICE_SERVICE"),
    S3_ON_DEVICE_SERVICE("S3_ON_DEVICE_SERVICE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceServiceName> VALUE_MAP;
    private final String value;

    private DeviceServiceName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceServiceName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceServiceName> knownValues() {
        EnumSet<DeviceServiceName> knownValues = EnumSet.allOf(DeviceServiceName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceServiceName.class, DeviceServiceName::toString);
    }
}

