/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.snowball.DefaultSnowballAsyncClient;
import software.amazon.awssdk.services.snowball.DefaultSnowballBaseClientBuilder;
import software.amazon.awssdk.services.snowball.SnowballAsyncClient;
import software.amazon.awssdk.services.snowball.SnowballAsyncClientBuilder;
import software.amazon.awssdk.services.snowball.SnowballServiceClientConfiguration;
import software.amazon.awssdk.services.snowball.endpoints.SnowballEndpointProvider;

@SdkInternalApi
final class DefaultSnowballAsyncClientBuilder
extends DefaultSnowballBaseClientBuilder<SnowballAsyncClientBuilder, SnowballAsyncClient>
implements SnowballAsyncClientBuilder {
    DefaultSnowballAsyncClientBuilder() {
    }

    @Override
    public DefaultSnowballAsyncClientBuilder endpointProvider(SnowballEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SnowballAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSnowballAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SnowballServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSnowballAsyncClient client = new DefaultSnowballAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SnowballServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SnowballServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

