/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains job logs. Whenever a Snow device is used to import data into or export data out of Amazon S3, you'll have
 * the option of downloading a PDF job report. Job logs are returned as a part of the response syntax of the
 * <code>DescribeJob</code> action in the <code>JobMetadata</code> data type. The job logs can be accessed for up to 60
 * minutes after this request has been made. To access any of the job logs after 60 minutes have passed, you'll have to
 * make another call to the <code>DescribeJob</code> action.
 * </p>
 * <p>
 * For import jobs, the PDF job report becomes available at the end of the import process. For export jobs, your job
 * report typically becomes available while the Snow device for your job part is being delivered to you.
 * </p>
 * <p>
 * The job report provides you insight into the state of your Amazon S3 data transfer. The report includes details about
 * your job or job part for your records.
 * </p>
 * <p>
 * For deeper visibility into the status of your transferred objects, you can look at the two associated logs: a success
 * log and a failure log. The logs are saved in comma-separated value (CSV) format, and the name of each log includes
 * the ID of the job or job part that the log describes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobLogs implements SdkPojo, Serializable, ToCopyableBuilder<JobLogs.Builder, JobLogs> {
    private static final SdkField<String> JOB_COMPLETION_REPORT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobCompletionReportURI").getter(getter(JobLogs::jobCompletionReportURI))
            .setter(setter(Builder::jobCompletionReportURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobCompletionReportURI").build())
            .build();

    private static final SdkField<String> JOB_SUCCESS_LOG_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobSuccessLogURI").getter(getter(JobLogs::jobSuccessLogURI)).setter(setter(Builder::jobSuccessLogURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobSuccessLogURI").build()).build();

    private static final SdkField<String> JOB_FAILURE_LOG_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobFailureLogURI").getter(getter(JobLogs::jobFailureLogURI)).setter(setter(Builder::jobFailureLogURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFailureLogURI").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            JOB_COMPLETION_REPORT_URI_FIELD, JOB_SUCCESS_LOG_URI_FIELD, JOB_FAILURE_LOG_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobCompletionReportURI;

    private final String jobSuccessLogURI;

    private final String jobFailureLogURI;

    private JobLogs(BuilderImpl builder) {
        this.jobCompletionReportURI = builder.jobCompletionReportURI;
        this.jobSuccessLogURI = builder.jobSuccessLogURI;
        this.jobFailureLogURI = builder.jobFailureLogURI;
    }

    /**
     * <p>
     * A link to an Amazon S3 presigned URL where the job completion report is located.
     * </p>
     * 
     * @return A link to an Amazon S3 presigned URL where the job completion report is located.
     */
    public final String jobCompletionReportURI() {
        return jobCompletionReportURI;
    }

    /**
     * <p>
     * A link to an Amazon S3 presigned URL where the job success log is located.
     * </p>
     * 
     * @return A link to an Amazon S3 presigned URL where the job success log is located.
     */
    public final String jobSuccessLogURI() {
        return jobSuccessLogURI;
    }

    /**
     * <p>
     * A link to an Amazon S3 presigned URL where the job failure log is located.
     * </p>
     * 
     * @return A link to an Amazon S3 presigned URL where the job failure log is located.
     */
    public final String jobFailureLogURI() {
        return jobFailureLogURI;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobCompletionReportURI());
        hashCode = 31 * hashCode + Objects.hashCode(jobSuccessLogURI());
        hashCode = 31 * hashCode + Objects.hashCode(jobFailureLogURI());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobLogs)) {
            return false;
        }
        JobLogs other = (JobLogs) obj;
        return Objects.equals(jobCompletionReportURI(), other.jobCompletionReportURI())
                && Objects.equals(jobSuccessLogURI(), other.jobSuccessLogURI())
                && Objects.equals(jobFailureLogURI(), other.jobFailureLogURI());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobLogs").add("JobCompletionReportURI", jobCompletionReportURI())
                .add("JobSuccessLogURI", jobSuccessLogURI()).add("JobFailureLogURI", jobFailureLogURI()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobCompletionReportURI":
            return Optional.ofNullable(clazz.cast(jobCompletionReportURI()));
        case "JobSuccessLogURI":
            return Optional.ofNullable(clazz.cast(jobSuccessLogURI()));
        case "JobFailureLogURI":
            return Optional.ofNullable(clazz.cast(jobFailureLogURI()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobLogs, T> g) {
        return obj -> g.apply((JobLogs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobLogs> {
        /**
         * <p>
         * A link to an Amazon S3 presigned URL where the job completion report is located.
         * </p>
         * 
         * @param jobCompletionReportURI
         *        A link to an Amazon S3 presigned URL where the job completion report is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobCompletionReportURI(String jobCompletionReportURI);

        /**
         * <p>
         * A link to an Amazon S3 presigned URL where the job success log is located.
         * </p>
         * 
         * @param jobSuccessLogURI
         *        A link to an Amazon S3 presigned URL where the job success log is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSuccessLogURI(String jobSuccessLogURI);

        /**
         * <p>
         * A link to an Amazon S3 presigned URL where the job failure log is located.
         * </p>
         * 
         * @param jobFailureLogURI
         *        A link to an Amazon S3 presigned URL where the job failure log is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobFailureLogURI(String jobFailureLogURI);
    }

    static final class BuilderImpl implements Builder {
        private String jobCompletionReportURI;

        private String jobSuccessLogURI;

        private String jobFailureLogURI;

        private BuilderImpl() {
        }

        private BuilderImpl(JobLogs model) {
            jobCompletionReportURI(model.jobCompletionReportURI);
            jobSuccessLogURI(model.jobSuccessLogURI);
            jobFailureLogURI(model.jobFailureLogURI);
        }

        public final String getJobCompletionReportURI() {
            return jobCompletionReportURI;
        }

        public final void setJobCompletionReportURI(String jobCompletionReportURI) {
            this.jobCompletionReportURI = jobCompletionReportURI;
        }

        @Override
        public final Builder jobCompletionReportURI(String jobCompletionReportURI) {
            this.jobCompletionReportURI = jobCompletionReportURI;
            return this;
        }

        public final String getJobSuccessLogURI() {
            return jobSuccessLogURI;
        }

        public final void setJobSuccessLogURI(String jobSuccessLogURI) {
            this.jobSuccessLogURI = jobSuccessLogURI;
        }

        @Override
        public final Builder jobSuccessLogURI(String jobSuccessLogURI) {
            this.jobSuccessLogURI = jobSuccessLogURI;
            return this;
        }

        public final String getJobFailureLogURI() {
            return jobFailureLogURI;
        }

        public final void setJobFailureLogURI(String jobFailureLogURI) {
            this.jobFailureLogURI = jobFailureLogURI;
        }

        @Override
        public final Builder jobFailureLogURI(String jobFailureLogURI) {
            this.jobFailureLogURI = jobFailureLogURI;
            return this;
        }

        @Override
        public JobLogs build() {
            return new JobLogs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
