/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TransferOption {
    IMPORT("IMPORT"),
    EXPORT("EXPORT"),
    LOCAL_USE("LOCAL_USE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TransferOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransferOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TransferOption.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransferOption> knownValues() {
        return Stream.of(TransferOption.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

