/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.CompatibleImage;
import software.amazon.awssdk.services.snowball.model.CompatibleImageListCopier;
import software.amazon.awssdk.services.snowball.model.SnowballResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCompatibleImagesResponse
extends SnowballResponse
implements ToCopyableBuilder<Builder, ListCompatibleImagesResponse> {
    private static final SdkField<List<CompatibleImage>> COMPATIBLE_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListCompatibleImagesResponse.getter(ListCompatibleImagesResponse::compatibleImages)).setter(ListCompatibleImagesResponse.setter(Builder::compatibleImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleImages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompatibleImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListCompatibleImagesResponse.getter(ListCompatibleImagesResponse::nextToken)).setter(ListCompatibleImagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPATIBLE_IMAGES_FIELD, NEXT_TOKEN_FIELD));
    private final List<CompatibleImage> compatibleImages;
    private final String nextToken;

    private ListCompatibleImagesResponse(BuilderImpl builder) {
        super(builder);
        this.compatibleImages = builder.compatibleImages;
        this.nextToken = builder.nextToken;
    }

    public boolean hasCompatibleImages() {
        return this.compatibleImages != null && !(this.compatibleImages instanceof SdkAutoConstructList);
    }

    public List<CompatibleImage> compatibleImages() {
        return this.compatibleImages;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibleImages());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCompatibleImagesResponse)) {
            return false;
        }
        ListCompatibleImagesResponse other = (ListCompatibleImagesResponse)((Object)obj);
        return Objects.equals(this.compatibleImages(), other.compatibleImages()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListCompatibleImagesResponse").add("CompatibleImages", this.compatibleImages()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompatibleImages": {
                return Optional.ofNullable(clazz.cast(this.compatibleImages()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCompatibleImagesResponse, T> g) {
        return obj -> g.apply((ListCompatibleImagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballResponse.BuilderImpl
    implements Builder {
        private List<CompatibleImage> compatibleImages = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCompatibleImagesResponse model) {
            super(model);
            this.compatibleImages(model.compatibleImages);
            this.nextToken(model.nextToken);
        }

        public final Collection<CompatibleImage.Builder> getCompatibleImages() {
            return this.compatibleImages != null ? (Collection)this.compatibleImages.stream().map(CompatibleImage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder compatibleImages(Collection<CompatibleImage> compatibleImages) {
            this.compatibleImages = CompatibleImageListCopier.copy(compatibleImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleImages(CompatibleImage ... compatibleImages) {
            this.compatibleImages(Arrays.asList(compatibleImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleImages(Consumer<CompatibleImage.Builder> ... compatibleImages) {
            this.compatibleImages(Stream.of(compatibleImages).map(c -> (CompatibleImage)((CompatibleImage.Builder)CompatibleImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCompatibleImages(Collection<CompatibleImage.BuilderImpl> compatibleImages) {
            this.compatibleImages = CompatibleImageListCopier.copyFromBuilder(compatibleImages);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCompatibleImagesResponse build() {
            return new ListCompatibleImagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowballResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCompatibleImagesResponse> {
        public Builder compatibleImages(Collection<CompatibleImage> var1);

        public Builder compatibleImages(CompatibleImage ... var1);

        public Builder compatibleImages(Consumer<CompatibleImage.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

