/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.KeyRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Resource> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Resource.getter(S3Resource::bucketArn)).setter(S3Resource.setter(Builder::bucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketArn").build()}).build();
    private static final SdkField<KeyRange> KEY_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(S3Resource.getter(S3Resource::keyRange)).setter(S3Resource.setter(Builder::keyRange)).constructor(KeyRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD, KEY_RANGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketArn;
    private final KeyRange keyRange;

    private S3Resource(BuilderImpl builder) {
        this.bucketArn = builder.bucketArn;
        this.keyRange = builder.keyRange;
    }

    public String bucketArn() {
        return this.bucketArn;
    }

    public KeyRange keyRange() {
        return this.keyRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyRange());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Resource)) {
            return false;
        }
        S3Resource other = (S3Resource)obj;
        return Objects.equals(this.bucketArn(), other.bucketArn()) && Objects.equals(this.keyRange(), other.keyRange());
    }

    public String toString() {
        return ToString.builder((String)"S3Resource").add("BucketArn", (Object)this.bucketArn()).add("KeyRange", (Object)this.keyRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketArn": {
                return Optional.ofNullable(clazz.cast(this.bucketArn()));
            }
            case "KeyRange": {
                return Optional.ofNullable(clazz.cast(this.keyRange()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Resource, T> g) {
        return obj -> g.apply((S3Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketArn;
        private KeyRange keyRange;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Resource model) {
            this.bucketArn(model.bucketArn);
            this.keyRange(model.keyRange);
        }

        public final String getBucketArn() {
            return this.bucketArn;
        }

        @Override
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        public final KeyRange.Builder getKeyRange() {
            return this.keyRange != null ? this.keyRange.toBuilder() : null;
        }

        @Override
        public final Builder keyRange(KeyRange keyRange) {
            this.keyRange = keyRange;
            return this;
        }

        public final void setKeyRange(KeyRange.BuilderImpl keyRange) {
            this.keyRange = keyRange != null ? keyRange.build() : null;
        }

        public S3Resource build() {
            return new S3Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Resource> {
        public Builder bucketArn(String var1);

        public Builder keyRange(KeyRange var1);

        default public Builder keyRange(Consumer<KeyRange.Builder> keyRange) {
            return this.keyRange((KeyRange)((KeyRange.Builder)KeyRange.builder().applyMutation(keyRange)).build());
        }
    }
}

