/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a key range. For export jobs, a <code>S3Resource</code> object can have an optional <code>KeyRange</code>
 * value. The length of the range is defined at job creation, and has either an inclusive <code>BeginMarker</code>, an
 * inclusive <code>EndMarker</code>, or both. Ranges are UTF-8 binary sorted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyRange implements SdkPojo, Serializable, ToCopyableBuilder<KeyRange.Builder, KeyRange> {
    private static final SdkField<String> BEGIN_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KeyRange::beginMarker)).setter(setter(Builder::beginMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginMarker").build()).build();

    private static final SdkField<String> END_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KeyRange::endMarker)).setter(setter(Builder::endMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_MARKER_FIELD,
            END_MARKER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String beginMarker;

    private final String endMarker;

    private KeyRange(BuilderImpl builder) {
        this.beginMarker = builder.beginMarker;
        this.endMarker = builder.endMarker;
    }

    /**
     * <p>
     * The key that starts an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.
     * </p>
     * 
     * @return The key that starts an optional key range for an export job. Ranges are inclusive and UTF-8 binary
     *         sorted.
     */
    public String beginMarker() {
        return beginMarker;
    }

    /**
     * <p>
     * The key that ends an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.
     * </p>
     * 
     * @return The key that ends an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.
     */
    public String endMarker() {
        return endMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginMarker());
        hashCode = 31 * hashCode + Objects.hashCode(endMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyRange)) {
            return false;
        }
        KeyRange other = (KeyRange) obj;
        return Objects.equals(beginMarker(), other.beginMarker()) && Objects.equals(endMarker(), other.endMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("KeyRange").add("BeginMarker", beginMarker()).add("EndMarker", endMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BeginMarker":
            return Optional.ofNullable(clazz.cast(beginMarker()));
        case "EndMarker":
            return Optional.ofNullable(clazz.cast(endMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyRange, T> g) {
        return obj -> g.apply((KeyRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyRange> {
        /**
         * <p>
         * The key that starts an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.
         * </p>
         * 
         * @param beginMarker
         *        The key that starts an optional key range for an export job. Ranges are inclusive and UTF-8 binary
         *        sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginMarker(String beginMarker);

        /**
         * <p>
         * The key that ends an optional key range for an export job. Ranges are inclusive and UTF-8 binary sorted.
         * </p>
         * 
         * @param endMarker
         *        The key that ends an optional key range for an export job. Ranges are inclusive and UTF-8 binary
         *        sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endMarker(String endMarker);
    }

    static final class BuilderImpl implements Builder {
        private String beginMarker;

        private String endMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyRange model) {
            beginMarker(model.beginMarker);
            endMarker(model.endMarker);
        }

        public final String getBeginMarker() {
            return beginMarker;
        }

        @Override
        public final Builder beginMarker(String beginMarker) {
            this.beginMarker = beginMarker;
            return this;
        }

        public final void setBeginMarker(String beginMarker) {
            this.beginMarker = beginMarker;
        }

        public final String getEndMarker() {
            return endMarker;
        }

        @Override
        public final Builder endMarker(String endMarker) {
            this.endMarker = endMarker;
            return this;
        }

        public final void setEndMarker(String endMarker) {
            this.endMarker = endMarker;
        }

        @Override
        public KeyRange build() {
            return new KeyRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
