/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SnowballCapacity {
    T50("T50"),
    T80("T80"),
    T100("T100"),
    T42("T42"),
    T98("T98"),
    NO_PREFERENCE("NoPreference"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SnowballCapacity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SnowballCapacity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SnowballCapacity.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SnowballCapacity> knownValues() {
        return Stream.of(SnowballCapacity.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

