/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.ShippingDetails;

@SdkInternalApi
public class ShippingDetailsMarshaller {
    private static final MarshallingInfo<String> SHIPPINGOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShippingOption").build();
    private static final MarshallingInfo<StructuredPojo> INBOUNDSHIPMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InboundShipment").build();
    private static final MarshallingInfo<StructuredPojo> OUTBOUNDSHIPMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutboundShipment").build();
    private static final ShippingDetailsMarshaller instance = new ShippingDetailsMarshaller();

    public static ShippingDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ShippingDetails shippingDetails, ProtocolMarshaller protocolMarshaller) {
        if (shippingDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)shippingDetails.shippingOption(), SHIPPINGOPTION_BINDING);
            protocolMarshaller.marshall((Object)shippingDetails.inboundShipment(), INBOUNDSHIPMENT_BINDING);
            protocolMarshaller.marshall((Object)shippingDetails.outboundShipment(), OUTBOUNDSHIPMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

