/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.DataTransfer;

@SdkInternalApi
public class DataTransferMarshaller {
    private static final MarshallingInfo<Long> BYTESTRANSFERRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BytesTransferred").build();
    private static final MarshallingInfo<Long> OBJECTSTRANSFERRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectsTransferred").build();
    private static final MarshallingInfo<Long> TOTALBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalBytes").build();
    private static final MarshallingInfo<Long> TOTALOBJECTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalObjects").build();
    private static final DataTransferMarshaller instance = new DataTransferMarshaller();

    public static DataTransferMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataTransfer dataTransfer, ProtocolMarshaller protocolMarshaller) {
        if (dataTransfer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataTransfer.bytesTransferred(), BYTESTRANSFERRED_BINDING);
            protocolMarshaller.marshall((Object)dataTransfer.objectsTransferred(), OBJECTSTRANSFERRED_BINDING);
            protocolMarshaller.marshall((Object)dataTransfer.totalBytes(), TOTALBYTES_BINDING);
            protocolMarshaller.marshall((Object)dataTransfer.totalObjects(), TOTALOBJECTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

