/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.Shipment;
import software.amazon.awssdk.services.snowball.model.ShippingOption;
import software.amazon.awssdk.services.snowball.transform.ShippingDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ShippingDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, ShippingDetails> {
    private final String shippingOption;
    private final Shipment inboundShipment;
    private final Shipment outboundShipment;

    private ShippingDetails(BuilderImpl builder) {
        this.shippingOption = builder.shippingOption;
        this.inboundShipment = builder.inboundShipment;
        this.outboundShipment = builder.outboundShipment;
    }

    public String shippingOption() {
        return this.shippingOption;
    }

    public Shipment inboundShipment() {
        return this.inboundShipment;
    }

    public Shipment outboundShipment() {
        return this.outboundShipment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.shippingOption() == null ? 0 : this.shippingOption().hashCode());
        hashCode = 31 * hashCode + (this.inboundShipment() == null ? 0 : this.inboundShipment().hashCode());
        hashCode = 31 * hashCode + (this.outboundShipment() == null ? 0 : this.outboundShipment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShippingDetails)) {
            return false;
        }
        ShippingDetails other = (ShippingDetails)obj;
        if (other.shippingOption() == null ^ this.shippingOption() == null) {
            return false;
        }
        if (other.shippingOption() != null && !other.shippingOption().equals(this.shippingOption())) {
            return false;
        }
        if (other.inboundShipment() == null ^ this.inboundShipment() == null) {
            return false;
        }
        if (other.inboundShipment() != null && !other.inboundShipment().equals(this.inboundShipment())) {
            return false;
        }
        if (other.outboundShipment() == null ^ this.outboundShipment() == null) {
            return false;
        }
        return other.outboundShipment() == null || other.outboundShipment().equals(this.outboundShipment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.shippingOption() != null) {
            sb.append("ShippingOption: ").append(this.shippingOption()).append(",");
        }
        if (this.inboundShipment() != null) {
            sb.append("InboundShipment: ").append(this.inboundShipment()).append(",");
        }
        if (this.outboundShipment() != null) {
            sb.append("OutboundShipment: ").append(this.outboundShipment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShippingDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String shippingOption;
        private Shipment inboundShipment;
        private Shipment outboundShipment;

        private BuilderImpl() {
        }

        private BuilderImpl(ShippingDetails model) {
            this.setShippingOption(model.shippingOption);
            this.setInboundShipment(model.inboundShipment);
            this.setOutboundShipment(model.outboundShipment);
        }

        public final String getShippingOption() {
            return this.shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final void setShippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
        }

        public final Shipment getInboundShipment() {
            return this.inboundShipment;
        }

        @Override
        public final Builder inboundShipment(Shipment inboundShipment) {
            this.inboundShipment = inboundShipment;
            return this;
        }

        public final void setInboundShipment(Shipment inboundShipment) {
            this.inboundShipment = inboundShipment;
        }

        public final Shipment getOutboundShipment() {
            return this.outboundShipment;
        }

        @Override
        public final Builder outboundShipment(Shipment outboundShipment) {
            this.outboundShipment = outboundShipment;
            return this;
        }

        public final void setOutboundShipment(Shipment outboundShipment) {
            this.outboundShipment = outboundShipment;
        }

        public ShippingDetails build() {
            return new ShippingDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ShippingDetails> {
        public Builder shippingOption(String var1);

        public Builder shippingOption(ShippingOption var1);

        public Builder inboundShipment(Shipment var1);

        public Builder outboundShipment(Shipment var1);
    }
}

