/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.EventTriggerDefinition;
import software.amazon.awssdk.services.snowball.model.EventTriggerDefinitionListCopier;
import software.amazon.awssdk.services.snowball.transform.LambdaResourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LambdaResource
implements StructuredPojo,
ToCopyableBuilder<Builder, LambdaResource> {
    private final String lambdaArn;
    private final List<EventTriggerDefinition> eventTriggers;

    private LambdaResource(BuilderImpl builder) {
        this.lambdaArn = builder.lambdaArn;
        this.eventTriggers = builder.eventTriggers;
    }

    public String lambdaArn() {
        return this.lambdaArn;
    }

    public List<EventTriggerDefinition> eventTriggers() {
        return this.eventTriggers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.lambdaArn() == null ? 0 : this.lambdaArn().hashCode());
        hashCode = 31 * hashCode + (this.eventTriggers() == null ? 0 : this.eventTriggers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaResource)) {
            return false;
        }
        LambdaResource other = (LambdaResource)obj;
        if (other.lambdaArn() == null ^ this.lambdaArn() == null) {
            return false;
        }
        if (other.lambdaArn() != null && !other.lambdaArn().equals(this.lambdaArn())) {
            return false;
        }
        if (other.eventTriggers() == null ^ this.eventTriggers() == null) {
            return false;
        }
        return other.eventTriggers() == null || other.eventTriggers().equals(this.eventTriggers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.lambdaArn() != null) {
            sb.append("LambdaArn: ").append(this.lambdaArn()).append(",");
        }
        if (this.eventTriggers() != null) {
            sb.append("EventTriggers: ").append(this.eventTriggers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LambdaResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String lambdaArn;
        private List<EventTriggerDefinition> eventTriggers;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaResource model) {
            this.setLambdaArn(model.lambdaArn);
            this.setEventTriggers(model.eventTriggers);
        }

        public final String getLambdaArn() {
            return this.lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        public final Collection<EventTriggerDefinition> getEventTriggers() {
            return this.eventTriggers;
        }

        @Override
        public final Builder eventTriggers(Collection<EventTriggerDefinition> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copy(eventTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggers(EventTriggerDefinition ... eventTriggers) {
            this.eventTriggers(Arrays.asList(eventTriggers));
            return this;
        }

        public final void setEventTriggers(Collection<EventTriggerDefinition> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copy(eventTriggers);
        }

        @SafeVarargs
        public final void setEventTriggers(EventTriggerDefinition ... eventTriggers) {
            this.eventTriggers(Arrays.asList(eventTriggers));
        }

        public LambdaResource build() {
            return new LambdaResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LambdaResource> {
        public Builder lambdaArn(String var1);

        public Builder eventTriggers(Collection<EventTriggerDefinition> var1);

        public Builder eventTriggers(EventTriggerDefinition ... var1);
    }
}

