/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.AppSummary;
import software.amazon.awssdk.services.sms.model.AppsCopier;
import software.amazon.awssdk.services.sms.model.SmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppsResponse
extends SmsResponse
implements ToCopyableBuilder<Builder, ListAppsResponse> {
    private static final SdkField<List<AppSummary>> APPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListAppsResponse.getter(ListAppsResponse::apps)).setter(ListAppsResponse.setter(Builder::apps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAppsResponse.getter(ListAppsResponse::nextToken)).setter(ListAppsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AppSummary> apps;
    private final String nextToken;

    private ListAppsResponse(BuilderImpl builder) {
        super(builder);
        this.apps = builder.apps;
        this.nextToken = builder.nextToken;
    }

    public List<AppSummary> apps() {
        return this.apps;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apps());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppsResponse)) {
            return false;
        }
        ListAppsResponse other = (ListAppsResponse)((Object)obj);
        return Objects.equals(this.apps(), other.apps()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAppsResponse").add("Apps", this.apps()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apps": {
                return Optional.ofNullable(clazz.cast(this.apps()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppsResponse, T> g) {
        return obj -> g.apply((ListAppsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsResponse.BuilderImpl
    implements Builder {
        private List<AppSummary> apps = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppsResponse model) {
            super(model);
            this.apps(model.apps);
            this.nextToken(model.nextToken);
        }

        public final Collection<AppSummary.Builder> getApps() {
            return this.apps != null ? (Collection)this.apps.stream().map(AppSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder apps(Collection<AppSummary> apps) {
            this.apps = AppsCopier.copy(apps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(AppSummary ... apps) {
            this.apps(Arrays.asList(apps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(Consumer<AppSummary.Builder> ... apps) {
            this.apps(Stream.of(apps).map(c -> (AppSummary)((AppSummary.Builder)AppSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApps(Collection<AppSummary.BuilderImpl> apps) {
            this.apps = AppsCopier.copyFromBuilder(apps);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAppsResponse build() {
            return new ListAppsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppsResponse> {
        public Builder apps(Collection<AppSummary> var1);

        public Builder apps(AppSummary ... var1);

        public Builder apps(Consumer<AppSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

