/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.Server;
import software.amazon.awssdk.services.sms.model.ServerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerGroup> {
    private static final SdkField<String> SERVER_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServerGroup.getter(ServerGroup::serverGroupId)).setter(ServerGroup.setter(Builder::serverGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServerGroup.getter(ServerGroup::name)).setter(ServerGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<Server>> SERVER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ServerGroup.getter(ServerGroup::serverList)).setter(ServerGroup.setter(Builder::serverList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Server::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_GROUP_ID_FIELD, NAME_FIELD, SERVER_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String serverGroupId;
    private final String name;
    private final List<Server> serverList;

    private ServerGroup(BuilderImpl builder) {
        this.serverGroupId = builder.serverGroupId;
        this.name = builder.name;
        this.serverList = builder.serverList;
    }

    public String serverGroupId() {
        return this.serverGroupId;
    }

    public String name() {
        return this.name;
    }

    public List<Server> serverList() {
        return this.serverList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerGroup)) {
            return false;
        }
        ServerGroup other = (ServerGroup)obj;
        return Objects.equals(this.serverGroupId(), other.serverGroupId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.serverList(), other.serverList());
    }

    public String toString() {
        return ToString.builder((String)"ServerGroup").add("ServerGroupId", (Object)this.serverGroupId()).add("Name", (Object)this.name()).add("ServerList", this.serverList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serverGroupId": {
                return Optional.ofNullable(clazz.cast(this.serverGroupId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "serverList": {
                return Optional.ofNullable(clazz.cast(this.serverList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerGroup, T> g) {
        return obj -> g.apply((ServerGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverGroupId;
        private String name;
        private List<Server> serverList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerGroup model) {
            this.serverGroupId(model.serverGroupId);
            this.name(model.name);
            this.serverList(model.serverList);
        }

        public final String getServerGroupId() {
            return this.serverGroupId;
        }

        @Override
        public final Builder serverGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
            return this;
        }

        public final void setServerGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Server.Builder> getServerList() {
            return this.serverList != null ? (Collection)this.serverList.stream().map(Server::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverList(Collection<Server> serverList) {
            this.serverList = ServerListCopier.copy(serverList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverList(Server ... serverList) {
            this.serverList(Arrays.asList(serverList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverList(Consumer<Server.Builder> ... serverList) {
            this.serverList(Stream.of(serverList).map(c -> (Server)((Server.Builder)Server.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerList(Collection<Server.BuilderImpl> serverList) {
            this.serverList = ServerListCopier.copyFromBuilder(serverList);
        }

        public ServerGroup build() {
            return new ServerGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerGroup> {
        public Builder serverGroupId(String var1);

        public Builder name(String var1);

        public Builder serverList(Collection<Server> var1);

        public Builder serverList(Server ... var1);

        public Builder serverList(Consumer<Server.Builder> ... var1);
    }
}

