/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.SmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAppRequest
extends SmsRequest
implements ToCopyableBuilder<Builder, DeleteAppRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteAppRequest.getter(DeleteAppRequest::appId)).setter(DeleteAppRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<Boolean> FORCE_STOP_APP_REPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DeleteAppRequest.getter(DeleteAppRequest::forceStopAppReplication)).setter(DeleteAppRequest.setter(Builder::forceStopAppReplication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceStopAppReplication").build()}).build();
    private static final SdkField<Boolean> FORCE_TERMINATE_APP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DeleteAppRequest.getter(DeleteAppRequest::forceTerminateApp)).setter(DeleteAppRequest.setter(Builder::forceTerminateApp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceTerminateApp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, FORCE_STOP_APP_REPLICATION_FIELD, FORCE_TERMINATE_APP_FIELD));
    private final String appId;
    private final Boolean forceStopAppReplication;
    private final Boolean forceTerminateApp;

    private DeleteAppRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.forceStopAppReplication = builder.forceStopAppReplication;
        this.forceTerminateApp = builder.forceTerminateApp;
    }

    public String appId() {
        return this.appId;
    }

    public Boolean forceStopAppReplication() {
        return this.forceStopAppReplication;
    }

    public Boolean forceTerminateApp() {
        return this.forceTerminateApp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceStopAppReplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceTerminateApp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAppRequest)) {
            return false;
        }
        DeleteAppRequest other = (DeleteAppRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.forceStopAppReplication(), other.forceStopAppReplication()) && Objects.equals(this.forceTerminateApp(), other.forceTerminateApp());
    }

    public String toString() {
        return ToString.builder((String)"DeleteAppRequest").add("AppId", (Object)this.appId()).add("ForceStopAppReplication", (Object)this.forceStopAppReplication()).add("ForceTerminateApp", (Object)this.forceTerminateApp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "forceStopAppReplication": {
                return Optional.ofNullable(clazz.cast(this.forceStopAppReplication()));
            }
            case "forceTerminateApp": {
                return Optional.ofNullable(clazz.cast(this.forceTerminateApp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAppRequest, T> g) {
        return obj -> g.apply((DeleteAppRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsRequest.BuilderImpl
    implements Builder {
        private String appId;
        private Boolean forceStopAppReplication;
        private Boolean forceTerminateApp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAppRequest model) {
            super(model);
            this.appId(model.appId);
            this.forceStopAppReplication(model.forceStopAppReplication);
            this.forceTerminateApp(model.forceTerminateApp);
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final Boolean getForceStopAppReplication() {
            return this.forceStopAppReplication;
        }

        @Override
        public final Builder forceStopAppReplication(Boolean forceStopAppReplication) {
            this.forceStopAppReplication = forceStopAppReplication;
            return this;
        }

        public final void setForceStopAppReplication(Boolean forceStopAppReplication) {
            this.forceStopAppReplication = forceStopAppReplication;
        }

        public final Boolean getForceTerminateApp() {
            return this.forceTerminateApp;
        }

        @Override
        public final Builder forceTerminateApp(Boolean forceTerminateApp) {
            this.forceTerminateApp = forceTerminateApp;
            return this;
        }

        public final void setForceTerminateApp(Boolean forceTerminateApp) {
            this.forceTerminateApp = forceTerminateApp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAppRequest build() {
            return new DeleteAppRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAppRequest> {
        public Builder appId(String var1);

        public Builder forceStopAppReplication(Boolean var1);

        public Builder forceTerminateApp(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

