/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.ServerValidationConfiguration;
import software.amazon.awssdk.services.sms.model.ServerValidationConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerGroupValidationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerGroupValidationConfiguration> {
    private static final SdkField<String> SERVER_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverGroupId").getter(ServerGroupValidationConfiguration.getter(ServerGroupValidationConfiguration::serverGroupId)).setter(ServerGroupValidationConfiguration.setter(Builder::serverGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupId").build()}).build();
    private static final SdkField<List<ServerValidationConfiguration>> SERVER_VALIDATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serverValidationConfigurations").getter(ServerGroupValidationConfiguration.getter(ServerGroupValidationConfiguration::serverValidationConfigurations)).setter(ServerGroupValidationConfiguration.setter(Builder::serverValidationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverValidationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerValidationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_GROUP_ID_FIELD, SERVER_VALIDATION_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServerGroupValidationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serverGroupId;
    private final List<ServerValidationConfiguration> serverValidationConfigurations;

    private ServerGroupValidationConfiguration(BuilderImpl builder) {
        this.serverGroupId = builder.serverGroupId;
        this.serverValidationConfigurations = builder.serverValidationConfigurations;
    }

    public final String serverGroupId() {
        return this.serverGroupId;
    }

    public final boolean hasServerValidationConfigurations() {
        return this.serverValidationConfigurations != null && !(this.serverValidationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ServerValidationConfiguration> serverValidationConfigurations() {
        return this.serverValidationConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServerValidationConfigurations() ? this.serverValidationConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerGroupValidationConfiguration)) {
            return false;
        }
        ServerGroupValidationConfiguration other = (ServerGroupValidationConfiguration)obj;
        return Objects.equals(this.serverGroupId(), other.serverGroupId()) && this.hasServerValidationConfigurations() == other.hasServerValidationConfigurations() && Objects.equals(this.serverValidationConfigurations(), other.serverValidationConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ServerGroupValidationConfiguration").add("ServerGroupId", (Object)this.serverGroupId()).add("ServerValidationConfigurations", this.hasServerValidationConfigurations() ? this.serverValidationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serverGroupId": {
                return Optional.ofNullable(clazz.cast(this.serverGroupId()));
            }
            case "serverValidationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.serverValidationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serverGroupId", SERVER_GROUP_ID_FIELD);
        map.put("serverValidationConfigurations", SERVER_VALIDATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerGroupValidationConfiguration, T> g) {
        return obj -> g.apply((ServerGroupValidationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverGroupId;
        private List<ServerValidationConfiguration> serverValidationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerGroupValidationConfiguration model) {
            this.serverGroupId(model.serverGroupId);
            this.serverValidationConfigurations(model.serverValidationConfigurations);
        }

        public final String getServerGroupId() {
            return this.serverGroupId;
        }

        public final void setServerGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
        }

        @Override
        public final Builder serverGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
            return this;
        }

        public final List<ServerValidationConfiguration.Builder> getServerValidationConfigurations() {
            List<ServerValidationConfiguration.Builder> result = ServerValidationConfigurationsCopier.copyToBuilder(this.serverValidationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerValidationConfigurations(Collection<ServerValidationConfiguration.BuilderImpl> serverValidationConfigurations) {
            this.serverValidationConfigurations = ServerValidationConfigurationsCopier.copyFromBuilder(serverValidationConfigurations);
        }

        @Override
        public final Builder serverValidationConfigurations(Collection<ServerValidationConfiguration> serverValidationConfigurations) {
            this.serverValidationConfigurations = ServerValidationConfigurationsCopier.copy(serverValidationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverValidationConfigurations(ServerValidationConfiguration ... serverValidationConfigurations) {
            this.serverValidationConfigurations(Arrays.asList(serverValidationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverValidationConfigurations(Consumer<ServerValidationConfiguration.Builder> ... serverValidationConfigurations) {
            this.serverValidationConfigurations(Stream.of(serverValidationConfigurations).map(c -> (ServerValidationConfiguration)((ServerValidationConfiguration.Builder)ServerValidationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServerGroupValidationConfiguration build() {
            return new ServerGroupValidationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerGroupValidationConfiguration> {
        public Builder serverGroupId(String var1);

        public Builder serverValidationConfigurations(Collection<ServerValidationConfiguration> var1);

        public Builder serverValidationConfigurations(ServerValidationConfiguration ... var1);

        public Builder serverValidationConfigurations(Consumer<ServerValidationConfiguration.Builder> ... var1);
    }
}

