/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VmManagerType {
    VSPHERE("VSPHERE"),
    SCVMM("SCVMM"),
    HYPERV_MANAGER("HYPERV-MANAGER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VmManagerType> VALUE_MAP;
    private final String value;

    private VmManagerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VmManagerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VmManagerType> knownValues() {
        EnumSet<VmManagerType> knownValues = EnumSet.allOf(VmManagerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VmManagerType.class, VmManagerType::toString);
    }
}

