/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.SmsResponse;
import software.amazon.awssdk.services.sms.model.ValidationOutput;
import software.amazon.awssdk.services.sms.model.ValidationOutputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAppValidationOutputResponse
extends SmsResponse
implements ToCopyableBuilder<Builder, GetAppValidationOutputResponse> {
    private static final SdkField<List<ValidationOutput>> VALIDATION_OUTPUT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validationOutputList").getter(GetAppValidationOutputResponse.getter(GetAppValidationOutputResponse::validationOutputList)).setter(GetAppValidationOutputResponse.setter(Builder::validationOutputList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationOutputList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_OUTPUT_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("validationOutputList", VALIDATION_OUTPUT_LIST_FIELD);
        }
    });
    private final List<ValidationOutput> validationOutputList;

    private GetAppValidationOutputResponse(BuilderImpl builder) {
        super(builder);
        this.validationOutputList = builder.validationOutputList;
    }

    public final boolean hasValidationOutputList() {
        return this.validationOutputList != null && !(this.validationOutputList instanceof SdkAutoConstructList);
    }

    public final List<ValidationOutput> validationOutputList() {
        return this.validationOutputList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationOutputList() ? this.validationOutputList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppValidationOutputResponse)) {
            return false;
        }
        GetAppValidationOutputResponse other = (GetAppValidationOutputResponse)((Object)obj);
        return this.hasValidationOutputList() == other.hasValidationOutputList() && Objects.equals(this.validationOutputList(), other.validationOutputList());
    }

    public final String toString() {
        return ToString.builder((String)"GetAppValidationOutputResponse").add("ValidationOutputList", this.hasValidationOutputList() ? this.validationOutputList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "validationOutputList": {
                return Optional.ofNullable(clazz.cast(this.validationOutputList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAppValidationOutputResponse, T> g) {
        return obj -> g.apply((GetAppValidationOutputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsResponse.BuilderImpl
    implements Builder {
        private List<ValidationOutput> validationOutputList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppValidationOutputResponse model) {
            super(model);
            this.validationOutputList(model.validationOutputList);
        }

        public final List<ValidationOutput.Builder> getValidationOutputList() {
            List<ValidationOutput.Builder> result = ValidationOutputListCopier.copyToBuilder(this.validationOutputList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationOutputList(Collection<ValidationOutput.BuilderImpl> validationOutputList) {
            this.validationOutputList = ValidationOutputListCopier.copyFromBuilder(validationOutputList);
        }

        @Override
        public final Builder validationOutputList(Collection<ValidationOutput> validationOutputList) {
            this.validationOutputList = ValidationOutputListCopier.copy(validationOutputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationOutputList(ValidationOutput ... validationOutputList) {
            this.validationOutputList(Arrays.asList(validationOutputList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationOutputList(Consumer<ValidationOutput.Builder> ... validationOutputList) {
            this.validationOutputList(Stream.of(validationOutputList).map(c -> (ValidationOutput)((ValidationOutput.Builder)ValidationOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetAppValidationOutputResponse build() {
            return new GetAppValidationOutputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAppValidationOutputResponse> {
        public Builder validationOutputList(Collection<ValidationOutput> var1);

        public Builder validationOutputList(ValidationOutput ... var1);

        public Builder validationOutputList(Consumer<ValidationOutput.Builder> ... var1);
    }
}

