/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sms.SmsClient;
import software.amazon.awssdk.services.sms.internal.UserAgentUtils;
import software.amazon.awssdk.services.sms.model.Connector;
import software.amazon.awssdk.services.sms.model.GetConnectorsRequest;
import software.amazon.awssdk.services.sms.model.GetConnectorsResponse;

public class GetConnectorsIterable
implements SdkIterable<GetConnectorsResponse> {
    private final SmsClient client;
    private final GetConnectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetConnectorsIterable(SmsClient client, GetConnectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetConnectorsResponseFetcher();
    }

    public Iterator<GetConnectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Connector> connectorList() {
        Function<GetConnectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectorList() != null) {
                return response.connectorList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetConnectorsResponseFetcher
    implements SyncPageFetcher<GetConnectorsResponse> {
        private GetConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(GetConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetConnectorsResponse nextPage(GetConnectorsResponse previousPage) {
            if (previousPage == null) {
                return GetConnectorsIterable.this.client.getConnectors(GetConnectorsIterable.this.firstRequest);
            }
            return GetConnectorsIterable.this.client.getConnectors((GetConnectorsRequest)((Object)GetConnectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

