/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.LicenseType;
import software.amazon.awssdk.services.sms.model.SmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateReplicationJobRequest
extends SmsRequest
implements ToCopyableBuilder<Builder, UpdateReplicationJobRequest> {
    private static final SdkField<String> REPLICATION_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationJobId").getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::replicationJobId)).setter(UpdateReplicationJobRequest.setter(Builder::replicationJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationJobId").build()}).build();
    private static final SdkField<Integer> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("frequency").getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::frequency)).setter(UpdateReplicationJobRequest.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()}).build();
    private static final SdkField<Instant> NEXT_REPLICATION_RUN_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("nextReplicationRunStartTime").getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::nextReplicationRunStartTime)).setter(UpdateReplicationJobRequest.setter(Builder::nextReplicationRunStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextReplicationRunStartTime").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseType").getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::licenseTypeAsString)).setter(UpdateReplicationJobRequest.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseType").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleName").getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::roleName)).setter(UpdateReplicationJobRequest.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::description)).setter(UpdateReplicationJobRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_RECENT_AMIS_TO_KEEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfRecentAmisToKeep").getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::numberOfRecentAmisToKeep)).setter(UpdateReplicationJobRequest.setter(Builder::numberOfRecentAmisToKeep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecentAmisToKeep").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("encrypted").getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::encrypted)).setter(UpdateReplicationJobRequest.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(UpdateReplicationJobRequest.getter(UpdateReplicationJobRequest::kmsKeyId)).setter(UpdateReplicationJobRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_JOB_ID_FIELD, FREQUENCY_FIELD, NEXT_REPLICATION_RUN_START_TIME_FIELD, LICENSE_TYPE_FIELD, ROLE_NAME_FIELD, DESCRIPTION_FIELD, NUMBER_OF_RECENT_AMIS_TO_KEEP_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD));
    private final String replicationJobId;
    private final Integer frequency;
    private final Instant nextReplicationRunStartTime;
    private final String licenseType;
    private final String roleName;
    private final String description;
    private final Integer numberOfRecentAmisToKeep;
    private final Boolean encrypted;
    private final String kmsKeyId;

    private UpdateReplicationJobRequest(BuilderImpl builder) {
        super(builder);
        this.replicationJobId = builder.replicationJobId;
        this.frequency = builder.frequency;
        this.nextReplicationRunStartTime = builder.nextReplicationRunStartTime;
        this.licenseType = builder.licenseType;
        this.roleName = builder.roleName;
        this.description = builder.description;
        this.numberOfRecentAmisToKeep = builder.numberOfRecentAmisToKeep;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final String replicationJobId() {
        return this.replicationJobId;
    }

    public final Integer frequency() {
        return this.frequency;
    }

    public final Instant nextReplicationRunStartTime() {
        return this.nextReplicationRunStartTime;
    }

    public final LicenseType licenseType() {
        return LicenseType.fromValue(this.licenseType);
    }

    public final String licenseTypeAsString() {
        return this.licenseType;
    }

    public final String roleName() {
        return this.roleName;
    }

    public final String description() {
        return this.description;
    }

    public final Integer numberOfRecentAmisToKeep() {
        return this.numberOfRecentAmisToKeep;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextReplicationRunStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRecentAmisToKeep());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReplicationJobRequest)) {
            return false;
        }
        UpdateReplicationJobRequest other = (UpdateReplicationJobRequest)((Object)obj);
        return Objects.equals(this.replicationJobId(), other.replicationJobId()) && Objects.equals(this.frequency(), other.frequency()) && Objects.equals(this.nextReplicationRunStartTime(), other.nextReplicationRunStartTime()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.numberOfRecentAmisToKeep(), other.numberOfRecentAmisToKeep()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateReplicationJobRequest").add("ReplicationJobId", (Object)this.replicationJobId()).add("Frequency", (Object)this.frequency()).add("NextReplicationRunStartTime", (Object)this.nextReplicationRunStartTime()).add("LicenseType", (Object)this.licenseTypeAsString()).add("RoleName", (Object)this.roleName()).add("Description", (Object)this.description()).add("NumberOfRecentAmisToKeep", (Object)this.numberOfRecentAmisToKeep()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replicationJobId": {
                return Optional.ofNullable(clazz.cast(this.replicationJobId()));
            }
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequency()));
            }
            case "nextReplicationRunStartTime": {
                return Optional.ofNullable(clazz.cast(this.nextReplicationRunStartTime()));
            }
            case "licenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "roleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "numberOfRecentAmisToKeep": {
                return Optional.ofNullable(clazz.cast(this.numberOfRecentAmisToKeep()));
            }
            case "encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReplicationJobRequest, T> g) {
        return obj -> g.apply((UpdateReplicationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsRequest.BuilderImpl
    implements Builder {
        private String replicationJobId;
        private Integer frequency;
        private Instant nextReplicationRunStartTime;
        private String licenseType;
        private String roleName;
        private String description;
        private Integer numberOfRecentAmisToKeep;
        private Boolean encrypted;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReplicationJobRequest model) {
            super(model);
            this.replicationJobId(model.replicationJobId);
            this.frequency(model.frequency);
            this.nextReplicationRunStartTime(model.nextReplicationRunStartTime);
            this.licenseType(model.licenseType);
            this.roleName(model.roleName);
            this.description(model.description);
            this.numberOfRecentAmisToKeep(model.numberOfRecentAmisToKeep);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getReplicationJobId() {
            return this.replicationJobId;
        }

        public final void setReplicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
        }

        @Override
        @Transient
        public final Builder replicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
            return this;
        }

        public final Integer getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        @Override
        @Transient
        public final Builder frequency(Integer frequency) {
            this.frequency = frequency;
            return this;
        }

        public final Instant getNextReplicationRunStartTime() {
            return this.nextReplicationRunStartTime;
        }

        public final void setNextReplicationRunStartTime(Instant nextReplicationRunStartTime) {
            this.nextReplicationRunStartTime = nextReplicationRunStartTime;
        }

        @Override
        @Transient
        public final Builder nextReplicationRunStartTime(Instant nextReplicationRunStartTime) {
            this.nextReplicationRunStartTime = nextReplicationRunStartTime;
            return this;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        @Transient
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        @Transient
        public final Builder licenseType(LicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        @Transient
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getNumberOfRecentAmisToKeep() {
            return this.numberOfRecentAmisToKeep;
        }

        public final void setNumberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep) {
            this.numberOfRecentAmisToKeep = numberOfRecentAmisToKeep;
        }

        @Override
        @Transient
        public final Builder numberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep) {
            this.numberOfRecentAmisToKeep = numberOfRecentAmisToKeep;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReplicationJobRequest build() {
            return new UpdateReplicationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateReplicationJobRequest> {
        public Builder replicationJobId(String var1);

        public Builder frequency(Integer var1);

        public Builder nextReplicationRunStartTime(Instant var1);

        public Builder licenseType(String var1);

        public Builder licenseType(LicenseType var1);

        public Builder roleName(String var1);

        public Builder description(String var1);

        public Builder numberOfRecentAmisToKeep(Integer var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

