/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateChangeSetRequest extends SmsRequest implements
        ToCopyableBuilder<GenerateChangeSetRequest.Builder, GenerateChangeSetRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(GenerateChangeSetRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> CHANGESET_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changesetFormat").getter(getter(GenerateChangeSetRequest::changesetFormatAsString))
            .setter(setter(Builder::changesetFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            CHANGESET_FORMAT_FIELD));

    private final String appId;

    private final String changesetFormat;

    private GenerateChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.changesetFormat = builder.changesetFormat;
    }

    /**
     * <p>
     * The ID of the application associated with the change set.
     * </p>
     * 
     * @return The ID of the application associated with the change set.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The format for the change set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changesetFormat}
     * will return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changesetFormatAsString}.
     * </p>
     * 
     * @return The format for the change set.
     * @see OutputFormat
     */
    public final OutputFormat changesetFormat() {
        return OutputFormat.fromValue(changesetFormat);
    }

    /**
     * <p>
     * The format for the change set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #changesetFormat}
     * will return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #changesetFormatAsString}.
     * </p>
     * 
     * @return The format for the change set.
     * @see OutputFormat
     */
    public final String changesetFormatAsString() {
        return changesetFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(changesetFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateChangeSetRequest)) {
            return false;
        }
        GenerateChangeSetRequest other = (GenerateChangeSetRequest) obj;
        return Objects.equals(appId(), other.appId())
                && Objects.equals(changesetFormatAsString(), other.changesetFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateChangeSetRequest").add("AppId", appId())
                .add("ChangesetFormat", changesetFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "changesetFormat":
            return Optional.ofNullable(clazz.cast(changesetFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateChangeSetRequest, T> g) {
        return obj -> g.apply((GenerateChangeSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GenerateChangeSetRequest> {
        /**
         * <p>
         * The ID of the application associated with the change set.
         * </p>
         * 
         * @param appId
         *        The ID of the application associated with the change set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The format for the change set.
         * </p>
         * 
         * @param changesetFormat
         *        The format for the change set.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder changesetFormat(String changesetFormat);

        /**
         * <p>
         * The format for the change set.
         * </p>
         * 
         * @param changesetFormat
         *        The format for the change set.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder changesetFormat(OutputFormat changesetFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SmsRequest.BuilderImpl implements Builder {
        private String appId;

        private String changesetFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateChangeSetRequest model) {
            super(model);
            appId(model.appId);
            changesetFormat(model.changesetFormat);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getChangesetFormat() {
            return changesetFormat;
        }

        @Override
        public final Builder changesetFormat(String changesetFormat) {
            this.changesetFormat = changesetFormat;
            return this;
        }

        @Override
        public final Builder changesetFormat(OutputFormat changesetFormat) {
            this.changesetFormat(changesetFormat == null ? null : changesetFormat.toString());
            return this;
        }

        public final void setChangesetFormat(String changesetFormat) {
            this.changesetFormat = changesetFormat;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateChangeSetRequest build() {
            return new GenerateChangeSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
