/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartOnDemandReplicationRunResponse extends SmsResponse implements
        ToCopyableBuilder<StartOnDemandReplicationRunResponse.Builder, StartOnDemandReplicationRunResponse> {
    private static final SdkField<String> REPLICATION_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartOnDemandReplicationRunResponse::replicationRunId)).setter(setter(Builder::replicationRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationRunId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_RUN_ID_FIELD));

    private final String replicationRunId;

    private StartOnDemandReplicationRunResponse(BuilderImpl builder) {
        super(builder);
        this.replicationRunId = builder.replicationRunId;
    }

    /**
     * <p>
     * The identifier of the replication run.
     * </p>
     * 
     * @return The identifier of the replication run.
     */
    public String replicationRunId() {
        return replicationRunId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationRunId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOnDemandReplicationRunResponse)) {
            return false;
        }
        StartOnDemandReplicationRunResponse other = (StartOnDemandReplicationRunResponse) obj;
        return Objects.equals(replicationRunId(), other.replicationRunId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartOnDemandReplicationRunResponse").add("ReplicationRunId", replicationRunId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replicationRunId":
            return Optional.ofNullable(clazz.cast(replicationRunId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartOnDemandReplicationRunResponse, T> g) {
        return obj -> g.apply((StartOnDemandReplicationRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartOnDemandReplicationRunResponse> {
        /**
         * <p>
         * The identifier of the replication run.
         * </p>
         * 
         * @param replicationRunId
         *        The identifier of the replication run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationRunId(String replicationRunId);
    }

    static final class BuilderImpl extends SmsResponse.BuilderImpl implements Builder {
        private String replicationRunId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartOnDemandReplicationRunResponse model) {
            super(model);
            replicationRunId(model.replicationRunId);
        }

        public final String getReplicationRunId() {
            return replicationRunId;
        }

        @Override
        public final Builder replicationRunId(String replicationRunId) {
            this.replicationRunId = replicationRunId;
            return this;
        }

        public final void setReplicationRunId(String replicationRunId) {
            this.replicationRunId = replicationRunId;
        }

        @Override
        public StartOnDemandReplicationRunResponse build() {
            return new StartOnDemandReplicationRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
