/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Launch configuration for a server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerLaunchConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerLaunchConfiguration.Builder, ServerLaunchConfiguration> {
    private static final SdkField<Server> SERVER_FIELD = SdkField.<Server> builder(MarshallingType.SDK_POJO)
            .getter(getter(ServerLaunchConfiguration::server)).setter(setter(Builder::server)).constructor(Server::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("server").build()).build();

    private static final SdkField<String> LOGICAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerLaunchConfiguration::logicalId)).setter(setter(Builder::logicalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalId").build()).build();

    private static final SdkField<String> VPC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerLaunchConfiguration::vpc)).setter(setter(Builder::vpc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()).build();

    private static final SdkField<String> SUBNET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerLaunchConfiguration::subnet)).setter(setter(Builder::subnet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnet").build()).build();

    private static final SdkField<String> SECURITY_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerLaunchConfiguration::securityGroup)).setter(setter(Builder::securityGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroup").build()).build();

    private static final SdkField<String> EC2_KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerLaunchConfiguration::ec2KeyName)).setter(setter(Builder::ec2KeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2KeyName").build()).build();

    private static final SdkField<UserData> USER_DATA_FIELD = SdkField.<UserData> builder(MarshallingType.SDK_POJO)
            .getter(getter(ServerLaunchConfiguration::userData)).setter(setter(Builder::userData)).constructor(UserData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userData").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerLaunchConfiguration::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(ServerLaunchConfiguration::associatePublicIpAddress))
            .setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatePublicIpAddress").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_FIELD,
            LOGICAL_ID_FIELD, VPC_FIELD, SUBNET_FIELD, SECURITY_GROUP_FIELD, EC2_KEY_NAME_FIELD, USER_DATA_FIELD,
            INSTANCE_TYPE_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Server server;

    private final String logicalId;

    private final String vpc;

    private final String subnet;

    private final String securityGroup;

    private final String ec2KeyName;

    private final UserData userData;

    private final String instanceType;

    private final Boolean associatePublicIpAddress;

    private ServerLaunchConfiguration(BuilderImpl builder) {
        this.server = builder.server;
        this.logicalId = builder.logicalId;
        this.vpc = builder.vpc;
        this.subnet = builder.subnet;
        this.securityGroup = builder.securityGroup;
        this.ec2KeyName = builder.ec2KeyName;
        this.userData = builder.userData;
        this.instanceType = builder.instanceType;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
    }

    /**
     * <p>
     * Identifier of the server the launch configuration is associated with.
     * </p>
     * 
     * @return Identifier of the server the launch configuration is associated with.
     */
    public Server server() {
        return server;
    }

    /**
     * <p>
     * Logical ID of the server in the Amazon CloudFormation template.
     * </p>
     * 
     * @return Logical ID of the server in the Amazon CloudFormation template.
     */
    public String logicalId() {
        return logicalId;
    }

    /**
     * <p>
     * Identifier of the VPC the server should be launched into.
     * </p>
     * 
     * @return Identifier of the VPC the server should be launched into.
     */
    public String vpc() {
        return vpc;
    }

    /**
     * <p>
     * Identifier of the subnet the server should be launched into.
     * </p>
     * 
     * @return Identifier of the subnet the server should be launched into.
     */
    public String subnet() {
        return subnet;
    }

    /**
     * <p>
     * Identifier of the security group that applies to the launched server.
     * </p>
     * 
     * @return Identifier of the security group that applies to the launched server.
     */
    public String securityGroup() {
        return securityGroup;
    }

    /**
     * <p>
     * Name of the EC2 SSH Key to be used for connecting to the launched server.
     * </p>
     * 
     * @return Name of the EC2 SSH Key to be used for connecting to the launched server.
     */
    public String ec2KeyName() {
        return ec2KeyName;
    }

    /**
     * <p>
     * Location of the user-data script to be executed when launching the server.
     * </p>
     * 
     * @return Location of the user-data script to be executed when launching the server.
     */
    public UserData userData() {
        return userData;
    }

    /**
     * <p>
     * Instance type to be used for launching the server.
     * </p>
     * 
     * @return Instance type to be used for launching the server.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * If true, a publicly accessible IP address is created when launching the server.
     * </p>
     * 
     * @return If true, a publicly accessible IP address is created when launching the server.
     */
    public Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(server());
        hashCode = 31 * hashCode + Objects.hashCode(logicalId());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(subnet());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(ec2KeyName());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerLaunchConfiguration)) {
            return false;
        }
        ServerLaunchConfiguration other = (ServerLaunchConfiguration) obj;
        return Objects.equals(server(), other.server()) && Objects.equals(logicalId(), other.logicalId())
                && Objects.equals(vpc(), other.vpc()) && Objects.equals(subnet(), other.subnet())
                && Objects.equals(securityGroup(), other.securityGroup()) && Objects.equals(ec2KeyName(), other.ec2KeyName())
                && Objects.equals(userData(), other.userData()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServerLaunchConfiguration").add("Server", server()).add("LogicalId", logicalId())
                .add("Vpc", vpc()).add("Subnet", subnet()).add("SecurityGroup", securityGroup()).add("Ec2KeyName", ec2KeyName())
                .add("UserData", userData()).add("InstanceType", instanceType())
                .add("AssociatePublicIpAddress", associatePublicIpAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "server":
            return Optional.ofNullable(clazz.cast(server()));
        case "logicalId":
            return Optional.ofNullable(clazz.cast(logicalId()));
        case "vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "subnet":
            return Optional.ofNullable(clazz.cast(subnet()));
        case "securityGroup":
            return Optional.ofNullable(clazz.cast(securityGroup()));
        case "ec2KeyName":
            return Optional.ofNullable(clazz.cast(ec2KeyName()));
        case "userData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "associatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerLaunchConfiguration, T> g) {
        return obj -> g.apply((ServerLaunchConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerLaunchConfiguration> {
        /**
         * <p>
         * Identifier of the server the launch configuration is associated with.
         * </p>
         * 
         * @param server
         *        Identifier of the server the launch configuration is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder server(Server server);

        /**
         * <p>
         * Identifier of the server the launch configuration is associated with.
         * </p>
         * This is a convenience that creates an instance of the {@link Server.Builder} avoiding the need to create one
         * manually via {@link Server#builder()}.
         *
         * When the {@link Consumer} completes, {@link Server.Builder#build()} is called immediately and its result is
         * passed to {@link #server(Server)}.
         * 
         * @param server
         *        a consumer that will call methods on {@link Server.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #server(Server)
         */
        default Builder server(Consumer<Server.Builder> server) {
            return server(Server.builder().applyMutation(server).build());
        }

        /**
         * <p>
         * Logical ID of the server in the Amazon CloudFormation template.
         * </p>
         * 
         * @param logicalId
         *        Logical ID of the server in the Amazon CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalId(String logicalId);

        /**
         * <p>
         * Identifier of the VPC the server should be launched into.
         * </p>
         * 
         * @param vpc
         *        Identifier of the VPC the server should be launched into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(String vpc);

        /**
         * <p>
         * Identifier of the subnet the server should be launched into.
         * </p>
         * 
         * @param subnet
         *        Identifier of the subnet the server should be launched into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnet(String subnet);

        /**
         * <p>
         * Identifier of the security group that applies to the launched server.
         * </p>
         * 
         * @param securityGroup
         *        Identifier of the security group that applies to the launched server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroup(String securityGroup);

        /**
         * <p>
         * Name of the EC2 SSH Key to be used for connecting to the launched server.
         * </p>
         * 
         * @param ec2KeyName
         *        Name of the EC2 SSH Key to be used for connecting to the launched server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2KeyName(String ec2KeyName);

        /**
         * <p>
         * Location of the user-data script to be executed when launching the server.
         * </p>
         * 
         * @param userData
         *        Location of the user-data script to be executed when launching the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(UserData userData);

        /**
         * <p>
         * Location of the user-data script to be executed when launching the server.
         * </p>
         * This is a convenience that creates an instance of the {@link UserData.Builder} avoiding the need to create
         * one manually via {@link UserData#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserData.Builder#build()} is called immediately and its result is
         * passed to {@link #userData(UserData)}.
         * 
         * @param userData
         *        a consumer that will call methods on {@link UserData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userData(UserData)
         */
        default Builder userData(Consumer<UserData.Builder> userData) {
            return userData(UserData.builder().applyMutation(userData).build());
        }

        /**
         * <p>
         * Instance type to be used for launching the server.
         * </p>
         * 
         * @param instanceType
         *        Instance type to be used for launching the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * If true, a publicly accessible IP address is created when launching the server.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        If true, a publicly accessible IP address is created when launching the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private Server server;

        private String logicalId;

        private String vpc;

        private String subnet;

        private String securityGroup;

        private String ec2KeyName;

        private UserData userData;

        private String instanceType;

        private Boolean associatePublicIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerLaunchConfiguration model) {
            server(model.server);
            logicalId(model.logicalId);
            vpc(model.vpc);
            subnet(model.subnet);
            securityGroup(model.securityGroup);
            ec2KeyName(model.ec2KeyName);
            userData(model.userData);
            instanceType(model.instanceType);
            associatePublicIpAddress(model.associatePublicIpAddress);
        }

        public final Server.Builder getServer() {
            return server != null ? server.toBuilder() : null;
        }

        @Override
        public final Builder server(Server server) {
            this.server = server;
            return this;
        }

        public final void setServer(Server.BuilderImpl server) {
            this.server = server != null ? server.build() : null;
        }

        public final String getLogicalId() {
            return logicalId;
        }

        @Override
        public final Builder logicalId(String logicalId) {
            this.logicalId = logicalId;
            return this;
        }

        public final void setLogicalId(String logicalId) {
            this.logicalId = logicalId;
        }

        public final String getVpc() {
            return vpc;
        }

        @Override
        public final Builder vpc(String vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(String vpc) {
            this.vpc = vpc;
        }

        public final String getSubnet() {
            return subnet;
        }

        @Override
        public final Builder subnet(String subnet) {
            this.subnet = subnet;
            return this;
        }

        public final void setSubnet(String subnet) {
            this.subnet = subnet;
        }

        public final String getSecurityGroup() {
            return securityGroup;
        }

        @Override
        public final Builder securityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public final void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        public final String getEc2KeyName() {
            return ec2KeyName;
        }

        @Override
        public final Builder ec2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
            return this;
        }

        public final void setEc2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
        }

        public final UserData.Builder getUserData() {
            return userData != null ? userData.toBuilder() : null;
        }

        @Override
        public final Builder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(UserData.BuilderImpl userData) {
            this.userData = userData != null ? userData.build() : null;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public ServerLaunchConfiguration build() {
            return new ServerLaunchConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
