/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Server implements SdkPojo, Serializable, ToCopyableBuilder<Server.Builder, Server> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Server::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverId").build()).build();

    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Server::serverTypeAsString)).setter(setter(Builder::serverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverType").build()).build();

    private static final SdkField<VmServer> VM_SERVER_FIELD = SdkField.<VmServer> builder(MarshallingType.SDK_POJO)
            .getter(getter(Server::vmServer)).setter(setter(Builder::vmServer)).constructor(VmServer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmServer").build()).build();

    private static final SdkField<String> REPLICATION_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Server::replicationJobId)).setter(setter(Builder::replicationJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationJobId").build()).build();

    private static final SdkField<Boolean> REPLICATION_JOB_TERMINATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Server::replicationJobTerminated)).setter(setter(Builder::replicationJobTerminated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationJobTerminated").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD,
            SERVER_TYPE_FIELD, VM_SERVER_FIELD, REPLICATION_JOB_ID_FIELD, REPLICATION_JOB_TERMINATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serverId;

    private final String serverType;

    private final VmServer vmServer;

    private final String replicationJobId;

    private final Boolean replicationJobTerminated;

    private Server(BuilderImpl builder) {
        this.serverId = builder.serverId;
        this.serverType = builder.serverType;
        this.vmServer = builder.vmServer;
        this.replicationJobId = builder.replicationJobId;
        this.replicationJobTerminated = builder.replicationJobTerminated;
    }

    /**
     * <p>
     * The identifier of the server.
     * </p>
     * 
     * @return The identifier of the server.
     */
    public String serverId() {
        return serverId;
    }

    /**
     * <p>
     * The type of server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The type of server.
     * @see ServerType
     */
    public ServerType serverType() {
        return ServerType.fromValue(serverType);
    }

    /**
     * <p>
     * The type of server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverType} will
     * return {@link ServerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverTypeAsString}.
     * </p>
     * 
     * @return The type of server.
     * @see ServerType
     */
    public String serverTypeAsString() {
        return serverType;
    }

    /**
     * <p>
     * Information about the VM server.
     * </p>
     * 
     * @return Information about the VM server.
     */
    public VmServer vmServer() {
        return vmServer;
    }

    /**
     * <p>
     * The identifier of the replication job.
     * </p>
     * 
     * @return The identifier of the replication job.
     */
    public String replicationJobId() {
        return replicationJobId;
    }

    /**
     * <p>
     * Indicates whether the replication job is deleted or failed.
     * </p>
     * 
     * @return Indicates whether the replication job is deleted or failed.
     */
    public Boolean replicationJobTerminated() {
        return replicationJobTerminated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(serverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vmServer());
        hashCode = 31 * hashCode + Objects.hashCode(replicationJobId());
        hashCode = 31 * hashCode + Objects.hashCode(replicationJobTerminated());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Server)) {
            return false;
        }
        Server other = (Server) obj;
        return Objects.equals(serverId(), other.serverId()) && Objects.equals(serverTypeAsString(), other.serverTypeAsString())
                && Objects.equals(vmServer(), other.vmServer()) && Objects.equals(replicationJobId(), other.replicationJobId())
                && Objects.equals(replicationJobTerminated(), other.replicationJobTerminated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Server").add("ServerId", serverId()).add("ServerType", serverTypeAsString())
                .add("VmServer", vmServer()).add("ReplicationJobId", replicationJobId())
                .add("ReplicationJobTerminated", replicationJobTerminated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "serverType":
            return Optional.ofNullable(clazz.cast(serverTypeAsString()));
        case "vmServer":
            return Optional.ofNullable(clazz.cast(vmServer()));
        case "replicationJobId":
            return Optional.ofNullable(clazz.cast(replicationJobId()));
        case "replicationJobTerminated":
            return Optional.ofNullable(clazz.cast(replicationJobTerminated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Server, T> g) {
        return obj -> g.apply((Server) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Server> {
        /**
         * <p>
         * The identifier of the server.
         * </p>
         * 
         * @param serverId
         *        The identifier of the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * The type of server.
         * </p>
         * 
         * @param serverType
         *        The type of server.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(String serverType);

        /**
         * <p>
         * The type of server.
         * </p>
         * 
         * @param serverType
         *        The type of server.
         * @see ServerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerType
         */
        Builder serverType(ServerType serverType);

        /**
         * <p>
         * Information about the VM server.
         * </p>
         * 
         * @param vmServer
         *        Information about the VM server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmServer(VmServer vmServer);

        /**
         * <p>
         * Information about the VM server.
         * </p>
         * This is a convenience that creates an instance of the {@link VmServer.Builder} avoiding the need to create
         * one manually via {@link VmServer#builder()}.
         *
         * When the {@link Consumer} completes, {@link VmServer.Builder#build()} is called immediately and its result is
         * passed to {@link #vmServer(VmServer)}.
         * 
         * @param vmServer
         *        a consumer that will call methods on {@link VmServer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vmServer(VmServer)
         */
        default Builder vmServer(Consumer<VmServer.Builder> vmServer) {
            return vmServer(VmServer.builder().applyMutation(vmServer).build());
        }

        /**
         * <p>
         * The identifier of the replication job.
         * </p>
         * 
         * @param replicationJobId
         *        The identifier of the replication job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationJobId(String replicationJobId);

        /**
         * <p>
         * Indicates whether the replication job is deleted or failed.
         * </p>
         * 
         * @param replicationJobTerminated
         *        Indicates whether the replication job is deleted or failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationJobTerminated(Boolean replicationJobTerminated);
    }

    static final class BuilderImpl implements Builder {
        private String serverId;

        private String serverType;

        private VmServer vmServer;

        private String replicationJobId;

        private Boolean replicationJobTerminated;

        private BuilderImpl() {
        }

        private BuilderImpl(Server model) {
            serverId(model.serverId);
            serverType(model.serverType);
            vmServer(model.vmServer);
            replicationJobId(model.replicationJobId);
            replicationJobTerminated(model.replicationJobTerminated);
        }

        public final String getServerId() {
            return serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final String getServerType() {
            return serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType == null ? null : serverType.toString());
            return this;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        public final VmServer.Builder getVmServer() {
            return vmServer != null ? vmServer.toBuilder() : null;
        }

        @Override
        public final Builder vmServer(VmServer vmServer) {
            this.vmServer = vmServer;
            return this;
        }

        public final void setVmServer(VmServer.BuilderImpl vmServer) {
            this.vmServer = vmServer != null ? vmServer.build() : null;
        }

        public final String getReplicationJobId() {
            return replicationJobId;
        }

        @Override
        public final Builder replicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
            return this;
        }

        public final void setReplicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
        }

        public final Boolean getReplicationJobTerminated() {
            return replicationJobTerminated;
        }

        @Override
        public final Builder replicationJobTerminated(Boolean replicationJobTerminated) {
            this.replicationJobTerminated = replicationJobTerminated;
            return this;
        }

        public final void setReplicationJobTerminated(Boolean replicationJobTerminated) {
            this.replicationJobTerminated = replicationJobTerminated;
        }

        @Override
        public Server build() {
            return new Server(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
