/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppsResponse extends SmsResponse implements ToCopyableBuilder<ListAppsResponse.Builder, ListAppsResponse> {
    private static final SdkField<List<AppSummary>> APPS_FIELD = SdkField
            .<List<AppSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListAppsResponse::apps))
            .setter(setter(Builder::apps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAppsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPS_FIELD, NEXT_TOKEN_FIELD));

    private final List<AppSummary> apps;

    private final String nextToken;

    private ListAppsResponse(BuilderImpl builder) {
        super(builder);
        this.apps = builder.apps;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Apps property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasApps() {
        return apps != null && !(apps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of application summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApps()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of application summaries.
     */
    public List<AppSummary> apps() {
        return apps;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is null when there are no more results
     *         to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apps());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppsResponse)) {
            return false;
        }
        ListAppsResponse other = (ListAppsResponse) obj;
        return Objects.equals(apps(), other.apps()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAppsResponse").add("Apps", apps()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apps":
            return Optional.ofNullable(clazz.cast(apps()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppsResponse, T> g) {
        return obj -> g.apply((ListAppsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAppsResponse> {
        /**
         * <p>
         * A list of application summaries.
         * </p>
         * 
         * @param apps
         *        A list of application summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apps(Collection<AppSummary> apps);

        /**
         * <p>
         * A list of application summaries.
         * </p>
         * 
         * @param apps
         *        A list of application summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apps(AppSummary... apps);

        /**
         * <p>
         * A list of application summaries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AppSummary>.Builder} avoiding the need to
         * create one manually via {@link List<AppSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AppSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #apps(List<AppSummary>)}.
         * 
         * @param apps
         *        a consumer that will call methods on {@link List<AppSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apps(List<AppSummary>)
         */
        Builder apps(Consumer<AppSummary.Builder>... apps);

        /**
         * <p>
         * The token required to retrieve the next set of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SmsResponse.BuilderImpl implements Builder {
        private List<AppSummary> apps = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppsResponse model) {
            super(model);
            apps(model.apps);
            nextToken(model.nextToken);
        }

        public final Collection<AppSummary.Builder> getApps() {
            return apps != null ? apps.stream().map(AppSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder apps(Collection<AppSummary> apps) {
            this.apps = AppsCopier.copy(apps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(AppSummary... apps) {
            apps(Arrays.asList(apps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(Consumer<AppSummary.Builder>... apps) {
            apps(Stream.of(apps).map(c -> AppSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApps(Collection<AppSummary.BuilderImpl> apps) {
            this.apps = AppsCopier.copyFromBuilder(apps);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAppsResponse build() {
            return new ListAppsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
