/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicationJobRequest extends SmsRequest implements
        ToCopyableBuilder<CreateReplicationJobRequest.Builder, CreateReplicationJobRequest> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationJobRequest::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverId").build()).build();

    private static final SdkField<Instant> SEED_REPLICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateReplicationJobRequest::seedReplicationTime)).setter(setter(Builder::seedReplicationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seedReplicationTime").build())
            .build();

    private static final SdkField<Integer> FREQUENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateReplicationJobRequest::frequency)).setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()).build();

    private static final SdkField<Boolean> RUN_ONCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateReplicationJobRequest::runOnce)).setter(setter(Builder::runOnce))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runOnce").build()).build();

    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationJobRequest::licenseTypeAsString)).setter(setter(Builder::licenseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseType").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationJobRequest::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationJobRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Integer> NUMBER_OF_RECENT_AMIS_TO_KEEP_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(CreateReplicationJobRequest::numberOfRecentAmisToKeep))
            .setter(setter(Builder::numberOfRecentAmisToKeep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecentAmisToKeep").build())
            .build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateReplicationJobRequest::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationJobRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD,
            SEED_REPLICATION_TIME_FIELD, FREQUENCY_FIELD, RUN_ONCE_FIELD, LICENSE_TYPE_FIELD, ROLE_NAME_FIELD, DESCRIPTION_FIELD,
            NUMBER_OF_RECENT_AMIS_TO_KEEP_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD));

    private final String serverId;

    private final Instant seedReplicationTime;

    private final Integer frequency;

    private final Boolean runOnce;

    private final String licenseType;

    private final String roleName;

    private final String description;

    private final Integer numberOfRecentAmisToKeep;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private CreateReplicationJobRequest(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.seedReplicationTime = builder.seedReplicationTime;
        this.frequency = builder.frequency;
        this.runOnce = builder.runOnce;
        this.licenseType = builder.licenseType;
        this.roleName = builder.roleName;
        this.description = builder.description;
        this.numberOfRecentAmisToKeep = builder.numberOfRecentAmisToKeep;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The identifier of the server.
     * </p>
     * 
     * @return The identifier of the server.
     */
    public String serverId() {
        return serverId;
    }

    /**
     * <p>
     * The seed replication time.
     * </p>
     * 
     * @return The seed replication time.
     */
    public Instant seedReplicationTime() {
        return seedReplicationTime;
    }

    /**
     * <p>
     * The time between consecutive replication runs, in hours.
     * </p>
     * 
     * @return The time between consecutive replication runs, in hours.
     */
    public Integer frequency() {
        return frequency;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Boolean runOnce() {
        return runOnce;
    }

    /**
     * <p>
     * The license type to be used for the AMI created by a successful replication run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link LicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The license type to be used for the AMI created by a successful replication run.
     * @see LicenseType
     */
    public LicenseType licenseType() {
        return LicenseType.fromValue(licenseType);
    }

    /**
     * <p>
     * The license type to be used for the AMI created by a successful replication run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link LicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The license type to be used for the AMI created by a successful replication run.
     * @see LicenseType
     */
    public String licenseTypeAsString() {
        return licenseType;
    }

    /**
     * <p>
     * The name of the IAM role to be used by the AWS SMS.
     * </p>
     * 
     * @return The name of the IAM role to be used by the AWS SMS.
     */
    public String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The description of the replication job.
     * </p>
     * 
     * @return The description of the replication job.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The maximum number of SMS-created AMIs to retain. The oldest will be deleted once the maximum number is reached
     * and a new AMI is created.
     * </p>
     * 
     * @return The maximum number of SMS-created AMIs to retain. The oldest will be deleted once the maximum number is
     *         reached and a new AMI is created.
     */
    public Integer numberOfRecentAmisToKeep() {
        return numberOfRecentAmisToKeep;
    }

    /**
     * <p>
     * When <i>true</i>, the replication job produces encrypted AMIs. See also <code>KmsKeyId</code> below.
     * </p>
     * 
     * @return When <i>true</i>, the replication job produces encrypted AMIs. See also <code>KmsKeyId</code> below.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * KMS key ID for replication jobs that produce encrypted AMIs. Can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KMS key ID
     * </p>
     * </li>
     * <li>
     * <p>
     * KMS key alias
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN referring to KMS key ID
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN referring to KMS key alias
     * </p>
     * </li>
     * </ul>
     * <p>
     * If encrypted is <i>true</i> but a KMS key id is not specified, the customer's default KMS key for EBS is used.
     * </p>
     * 
     * @return KMS key ID for replication jobs that produce encrypted AMIs. Can be any of the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         KMS key ID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         KMS key alias
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN referring to KMS key ID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN referring to KMS key alias
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If encrypted is <i>true</i> but a KMS key id is not specified, the customer's default KMS key for EBS is
     *         used.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(seedReplicationTime());
        hashCode = 31 * hashCode + Objects.hashCode(frequency());
        hashCode = 31 * hashCode + Objects.hashCode(runOnce());
        hashCode = 31 * hashCode + Objects.hashCode(licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRecentAmisToKeep());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationJobRequest)) {
            return false;
        }
        CreateReplicationJobRequest other = (CreateReplicationJobRequest) obj;
        return Objects.equals(serverId(), other.serverId()) && Objects.equals(seedReplicationTime(), other.seedReplicationTime())
                && Objects.equals(frequency(), other.frequency()) && Objects.equals(runOnce(), other.runOnce())
                && Objects.equals(licenseTypeAsString(), other.licenseTypeAsString())
                && Objects.equals(roleName(), other.roleName()) && Objects.equals(description(), other.description())
                && Objects.equals(numberOfRecentAmisToKeep(), other.numberOfRecentAmisToKeep())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateReplicationJobRequest").add("ServerId", serverId())
                .add("SeedReplicationTime", seedReplicationTime()).add("Frequency", frequency()).add("RunOnce", runOnce())
                .add("LicenseType", licenseTypeAsString()).add("RoleName", roleName()).add("Description", description())
                .add("NumberOfRecentAmisToKeep", numberOfRecentAmisToKeep()).add("Encrypted", encrypted())
                .add("KmsKeyId", kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "seedReplicationTime":
            return Optional.ofNullable(clazz.cast(seedReplicationTime()));
        case "frequency":
            return Optional.ofNullable(clazz.cast(frequency()));
        case "runOnce":
            return Optional.ofNullable(clazz.cast(runOnce()));
        case "licenseType":
            return Optional.ofNullable(clazz.cast(licenseTypeAsString()));
        case "roleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "numberOfRecentAmisToKeep":
            return Optional.ofNullable(clazz.cast(numberOfRecentAmisToKeep()));
        case "encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationJobRequest, T> g) {
        return obj -> g.apply((CreateReplicationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateReplicationJobRequest> {
        /**
         * <p>
         * The identifier of the server.
         * </p>
         * 
         * @param serverId
         *        The identifier of the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * The seed replication time.
         * </p>
         * 
         * @param seedReplicationTime
         *        The seed replication time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seedReplicationTime(Instant seedReplicationTime);

        /**
         * <p>
         * The time between consecutive replication runs, in hours.
         * </p>
         * 
         * @param frequency
         *        The time between consecutive replication runs, in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequency(Integer frequency);

        /**
         * <p/>
         * 
         * @param runOnce
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runOnce(Boolean runOnce);

        /**
         * <p>
         * The license type to be used for the AMI created by a successful replication run.
         * </p>
         * 
         * @param licenseType
         *        The license type to be used for the AMI created by a successful replication run.
         * @see LicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseType
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The license type to be used for the AMI created by a successful replication run.
         * </p>
         * 
         * @param licenseType
         *        The license type to be used for the AMI created by a successful replication run.
         * @see LicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseType
         */
        Builder licenseType(LicenseType licenseType);

        /**
         * <p>
         * The name of the IAM role to be used by the AWS SMS.
         * </p>
         * 
         * @param roleName
         *        The name of the IAM role to be used by the AWS SMS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The description of the replication job.
         * </p>
         * 
         * @param description
         *        The description of the replication job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The maximum number of SMS-created AMIs to retain. The oldest will be deleted once the maximum number is
         * reached and a new AMI is created.
         * </p>
         * 
         * @param numberOfRecentAmisToKeep
         *        The maximum number of SMS-created AMIs to retain. The oldest will be deleted once the maximum number
         *        is reached and a new AMI is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep);

        /**
         * <p>
         * When <i>true</i>, the replication job produces encrypted AMIs. See also <code>KmsKeyId</code> below.
         * </p>
         * 
         * @param encrypted
         *        When <i>true</i>, the replication job produces encrypted AMIs. See also <code>KmsKeyId</code> below.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * KMS key ID for replication jobs that produce encrypted AMIs. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KMS key ID
         * </p>
         * </li>
         * <li>
         * <p>
         * KMS key alias
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN referring to KMS key ID
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN referring to KMS key alias
         * </p>
         * </li>
         * </ul>
         * <p>
         * If encrypted is <i>true</i> but a KMS key id is not specified, the customer's default KMS key for EBS is
         * used.
         * </p>
         * 
         * @param kmsKeyId
         *        KMS key ID for replication jobs that produce encrypted AMIs. Can be any of the following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        KMS key ID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KMS key alias
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN referring to KMS key ID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN referring to KMS key alias
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If encrypted is <i>true</i> but a KMS key id is not specified, the customer's default KMS key for EBS
         *        is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SmsRequest.BuilderImpl implements Builder {
        private String serverId;

        private Instant seedReplicationTime;

        private Integer frequency;

        private Boolean runOnce;

        private String licenseType;

        private String roleName;

        private String description;

        private Integer numberOfRecentAmisToKeep;

        private Boolean encrypted;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationJobRequest model) {
            super(model);
            serverId(model.serverId);
            seedReplicationTime(model.seedReplicationTime);
            frequency(model.frequency);
            runOnce(model.runOnce);
            licenseType(model.licenseType);
            roleName(model.roleName);
            description(model.description);
            numberOfRecentAmisToKeep(model.numberOfRecentAmisToKeep);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getServerId() {
            return serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final Instant getSeedReplicationTime() {
            return seedReplicationTime;
        }

        @Override
        public final Builder seedReplicationTime(Instant seedReplicationTime) {
            this.seedReplicationTime = seedReplicationTime;
            return this;
        }

        public final void setSeedReplicationTime(Instant seedReplicationTime) {
            this.seedReplicationTime = seedReplicationTime;
        }

        public final Integer getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(Integer frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        public final Boolean getRunOnce() {
            return runOnce;
        }

        @Override
        public final Builder runOnce(Boolean runOnce) {
            this.runOnce = runOnce;
            return this;
        }

        public final void setRunOnce(Boolean runOnce) {
            this.runOnce = runOnce;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(LicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getNumberOfRecentAmisToKeep() {
            return numberOfRecentAmisToKeep;
        }

        @Override
        public final Builder numberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep) {
            this.numberOfRecentAmisToKeep = numberOfRecentAmisToKeep;
            return this;
        }

        public final void setNumberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep) {
            this.numberOfRecentAmisToKeep = numberOfRecentAmisToKeep;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationJobRequest build() {
            return new CreateReplicationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
