/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppRequest extends SmsRequest implements ToCopyableBuilder<CreateAppRequest.Builder, CreateAppRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppRequest::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAppRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<List<ServerGroup>> SERVER_GROUPS_FIELD = SdkField
            .<List<ServerGroup>> builder(MarshallingType.LIST)
            .getter(getter(CreateAppRequest::serverGroups))
            .setter(setter(Builder::serverGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateAppRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ROLE_NAME_FIELD, CLIENT_TOKEN_FIELD, SERVER_GROUPS_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final String roleName;

    private final String clientToken;

    private final List<ServerGroup> serverGroups;

    private final List<Tag> tags;

    private CreateAppRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.roleName = builder.roleName;
        this.clientToken = builder.clientToken;
        this.serverGroups = builder.serverGroups;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Name of the new application.
     * </p>
     * 
     * @return Name of the new application.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Description of the new application
     * </p>
     * 
     * @return Description of the new application
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Name of service role in customer's account to be used by AWS SMS.
     * </p>
     * 
     * @return Name of service role in customer's account to be used by AWS SMS.
     */
    public String roleName() {
        return roleName;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier you provide to ensure idempotency of application creation.
     * </p>
     * 
     * @return A unique, case-sensitive identifier you provide to ensure idempotency of application creation.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the ServerGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasServerGroups() {
        return serverGroups != null && !(serverGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of server groups to include in the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServerGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of server groups to include in the application.
     */
    public List<ServerGroup> serverGroups() {
        return serverGroups;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of tags to be associated with the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of tags to be associated with the application.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(serverGroups());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(roleName(), other.roleName()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(serverGroups(), other.serverGroups()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateAppRequest").add("Name", name()).add("Description", description())
                .add("RoleName", roleName()).add("ClientToken", clientToken()).add("ServerGroups", serverGroups())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "roleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "serverGroups":
            return Optional.ofNullable(clazz.cast(serverGroups()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppRequest, T> g) {
        return obj -> g.apply((CreateAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAppRequest> {
        /**
         * <p>
         * Name of the new application.
         * </p>
         * 
         * @param name
         *        Name of the new application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description of the new application
         * </p>
         * 
         * @param description
         *        Description of the new application
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Name of service role in customer's account to be used by AWS SMS.
         * </p>
         * 
         * @param roleName
         *        Name of service role in customer's account to be used by AWS SMS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * A unique, case-sensitive identifier you provide to ensure idempotency of application creation.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier you provide to ensure idempotency of application creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * List of server groups to include in the application.
         * </p>
         * 
         * @param serverGroups
         *        List of server groups to include in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroups(Collection<ServerGroup> serverGroups);

        /**
         * <p>
         * List of server groups to include in the application.
         * </p>
         * 
         * @param serverGroups
         *        List of server groups to include in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroups(ServerGroup... serverGroups);

        /**
         * <p>
         * List of server groups to include in the application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServerGroup>.Builder} avoiding the need to
         * create one manually via {@link List<ServerGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServerGroup>.Builder#build()} is called immediately and its
         * result is passed to {@link #serverGroups(List<ServerGroup>)}.
         * 
         * @param serverGroups
         *        a consumer that will call methods on {@link List<ServerGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverGroups(List<ServerGroup>)
         */
        Builder serverGroups(Consumer<ServerGroup.Builder>... serverGroups);

        /**
         * <p>
         * List of tags to be associated with the application.
         * </p>
         * 
         * @param tags
         *        List of tags to be associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * List of tags to be associated with the application.
         * </p>
         * 
         * @param tags
         *        List of tags to be associated with the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * List of tags to be associated with the application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SmsRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String roleName;

        private String clientToken;

        private List<ServerGroup> serverGroups = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            roleName(model.roleName);
            clientToken(model.clientToken);
            serverGroups(model.serverGroups);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<ServerGroup.Builder> getServerGroups() {
            return serverGroups != null ? serverGroups.stream().map(ServerGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverGroups(Collection<ServerGroup> serverGroups) {
            this.serverGroups = ServerGroupsCopier.copy(serverGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroups(ServerGroup... serverGroups) {
            serverGroups(Arrays.asList(serverGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroups(Consumer<ServerGroup.Builder>... serverGroups) {
            serverGroups(Stream.of(serverGroups).map(c -> ServerGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setServerGroups(Collection<ServerGroup.BuilderImpl> serverGroups) {
            this.serverGroups = ServerGroupsCopier.copyFromBuilder(serverGroups);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
