/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Replication parameters for replicating a server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerReplicationParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerReplicationParameters.Builder, ServerReplicationParameters> {
    private static final SdkField<Instant> SEED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ServerReplicationParameters::seedTime)).setter(setter(Builder::seedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seedTime").build()).build();

    private static final SdkField<Integer> FREQUENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ServerReplicationParameters::frequency)).setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()).build();

    private static final SdkField<Boolean> RUN_ONCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ServerReplicationParameters::runOnce)).setter(setter(Builder::runOnce))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runOnce").build()).build();

    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerReplicationParameters::licenseTypeAsString)).setter(setter(Builder::licenseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseType").build()).build();

    private static final SdkField<Integer> NUMBER_OF_RECENT_AMIS_TO_KEEP_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(ServerReplicationParameters::numberOfRecentAmisToKeep))
            .setter(setter(Builder::numberOfRecentAmisToKeep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecentAmisToKeep").build())
            .build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ServerReplicationParameters::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerReplicationParameters::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEED_TIME_FIELD,
            FREQUENCY_FIELD, RUN_ONCE_FIELD, LICENSE_TYPE_FIELD, NUMBER_OF_RECENT_AMIS_TO_KEEP_FIELD, ENCRYPTED_FIELD,
            KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant seedTime;

    private final Integer frequency;

    private final Boolean runOnce;

    private final String licenseType;

    private final Integer numberOfRecentAmisToKeep;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private ServerReplicationParameters(BuilderImpl builder) {
        this.seedTime = builder.seedTime;
        this.frequency = builder.frequency;
        this.runOnce = builder.runOnce;
        this.licenseType = builder.licenseType;
        this.numberOfRecentAmisToKeep = builder.numberOfRecentAmisToKeep;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * Seed time for creating a replication job for the server.
     * </p>
     * 
     * @return Seed time for creating a replication job for the server.
     */
    public Instant seedTime() {
        return seedTime;
    }

    /**
     * <p>
     * Frequency of creating replication jobs for the server.
     * </p>
     * 
     * @return Frequency of creating replication jobs for the server.
     */
    public Integer frequency() {
        return frequency;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Boolean runOnce() {
        return runOnce;
    }

    /**
     * <p>
     * License type for creating a replication job for the server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link LicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return License type for creating a replication job for the server.
     * @see LicenseType
     */
    public LicenseType licenseType() {
        return LicenseType.fromValue(licenseType);
    }

    /**
     * <p>
     * License type for creating a replication job for the server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link LicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return License type for creating a replication job for the server.
     * @see LicenseType
     */
    public String licenseTypeAsString() {
        return licenseType;
    }

    /**
     * <p>
     * Number of recent AMIs to keep when creating a replication job for this server.
     * </p>
     * 
     * @return Number of recent AMIs to keep when creating a replication job for this server.
     */
    public Integer numberOfRecentAmisToKeep() {
        return numberOfRecentAmisToKeep;
    }

    /**
     * <p>
     * When true, the replication job produces encrypted AMIs. See also <code>KmsKeyId</code> below.
     * </p>
     * 
     * @return When true, the replication job produces encrypted AMIs. See also <code>KmsKeyId</code> below.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p/>
     * <p>
     * KMS key ID for replication jobs that produce encrypted AMIs. Can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KMS key ID
     * </p>
     * </li>
     * <li>
     * <p>
     * KMS key alias
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN referring to KMS key ID
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN referring to KMS key alias
     * </p>
     * </li>
     * </ul>
     * <p>
     * If encrypted is <i>true</i> but a KMS key id is not specified, the customer's default KMS key for EBS is used.
     * </p>
     * 
     * @return <p>
     *         KMS key ID for replication jobs that produce encrypted AMIs. Can be any of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         KMS key ID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         KMS key alias
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN referring to KMS key ID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN referring to KMS key alias
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If encrypted is <i>true</i> but a KMS key id is not specified, the customer's default KMS key for EBS is
     *         used.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(seedTime());
        hashCode = 31 * hashCode + Objects.hashCode(frequency());
        hashCode = 31 * hashCode + Objects.hashCode(runOnce());
        hashCode = 31 * hashCode + Objects.hashCode(licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRecentAmisToKeep());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerReplicationParameters)) {
            return false;
        }
        ServerReplicationParameters other = (ServerReplicationParameters) obj;
        return Objects.equals(seedTime(), other.seedTime()) && Objects.equals(frequency(), other.frequency())
                && Objects.equals(runOnce(), other.runOnce())
                && Objects.equals(licenseTypeAsString(), other.licenseTypeAsString())
                && Objects.equals(numberOfRecentAmisToKeep(), other.numberOfRecentAmisToKeep())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServerReplicationParameters").add("SeedTime", seedTime()).add("Frequency", frequency())
                .add("RunOnce", runOnce()).add("LicenseType", licenseTypeAsString())
                .add("NumberOfRecentAmisToKeep", numberOfRecentAmisToKeep()).add("Encrypted", encrypted())
                .add("KmsKeyId", kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "seedTime":
            return Optional.ofNullable(clazz.cast(seedTime()));
        case "frequency":
            return Optional.ofNullable(clazz.cast(frequency()));
        case "runOnce":
            return Optional.ofNullable(clazz.cast(runOnce()));
        case "licenseType":
            return Optional.ofNullable(clazz.cast(licenseTypeAsString()));
        case "numberOfRecentAmisToKeep":
            return Optional.ofNullable(clazz.cast(numberOfRecentAmisToKeep()));
        case "encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerReplicationParameters, T> g) {
        return obj -> g.apply((ServerReplicationParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerReplicationParameters> {
        /**
         * <p>
         * Seed time for creating a replication job for the server.
         * </p>
         * 
         * @param seedTime
         *        Seed time for creating a replication job for the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seedTime(Instant seedTime);

        /**
         * <p>
         * Frequency of creating replication jobs for the server.
         * </p>
         * 
         * @param frequency
         *        Frequency of creating replication jobs for the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequency(Integer frequency);

        /**
         * <p/>
         * 
         * @param runOnce
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runOnce(Boolean runOnce);

        /**
         * <p>
         * License type for creating a replication job for the server.
         * </p>
         * 
         * @param licenseType
         *        License type for creating a replication job for the server.
         * @see LicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseType
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * License type for creating a replication job for the server.
         * </p>
         * 
         * @param licenseType
         *        License type for creating a replication job for the server.
         * @see LicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseType
         */
        Builder licenseType(LicenseType licenseType);

        /**
         * <p>
         * Number of recent AMIs to keep when creating a replication job for this server.
         * </p>
         * 
         * @param numberOfRecentAmisToKeep
         *        Number of recent AMIs to keep when creating a replication job for this server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep);

        /**
         * <p>
         * When true, the replication job produces encrypted AMIs. See also <code>KmsKeyId</code> below.
         * </p>
         * 
         * @param encrypted
         *        When true, the replication job produces encrypted AMIs. See also <code>KmsKeyId</code> below.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p/>
         * <p>
         * KMS key ID for replication jobs that produce encrypted AMIs. Can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KMS key ID
         * </p>
         * </li>
         * <li>
         * <p>
         * KMS key alias
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN referring to KMS key ID
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN referring to KMS key alias
         * </p>
         * </li>
         * </ul>
         * <p>
         * If encrypted is <i>true</i> but a KMS key id is not specified, the customer's default KMS key for EBS is
         * used.
         * </p>
         * 
         * @param kmsKeyId
         *        <p>
         *        KMS key ID for replication jobs that produce encrypted AMIs. Can be any of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        KMS key ID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        KMS key alias
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN referring to KMS key ID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN referring to KMS key alias
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If encrypted is <i>true</i> but a KMS key id is not specified, the customer's default KMS key for EBS
         *        is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private Instant seedTime;

        private Integer frequency;

        private Boolean runOnce;

        private String licenseType;

        private Integer numberOfRecentAmisToKeep;

        private Boolean encrypted;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerReplicationParameters model) {
            seedTime(model.seedTime);
            frequency(model.frequency);
            runOnce(model.runOnce);
            licenseType(model.licenseType);
            numberOfRecentAmisToKeep(model.numberOfRecentAmisToKeep);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
        }

        public final Instant getSeedTime() {
            return seedTime;
        }

        @Override
        public final Builder seedTime(Instant seedTime) {
            this.seedTime = seedTime;
            return this;
        }

        public final void setSeedTime(Instant seedTime) {
            this.seedTime = seedTime;
        }

        public final Integer getFrequency() {
            return frequency;
        }

        @Override
        public final Builder frequency(Integer frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        public final Boolean getRunOnce() {
            return runOnce;
        }

        @Override
        public final Builder runOnce(Boolean runOnce) {
            this.runOnce = runOnce;
            return this;
        }

        public final void setRunOnce(Boolean runOnce) {
            this.runOnce = runOnce;
        }

        public final String getLicenseTypeAsString() {
            return licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(LicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final Integer getNumberOfRecentAmisToKeep() {
            return numberOfRecentAmisToKeep;
        }

        @Override
        public final Builder numberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep) {
            this.numberOfRecentAmisToKeep = numberOfRecentAmisToKeep;
            return this;
        }

        public final void setNumberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep) {
            this.numberOfRecentAmisToKeep = numberOfRecentAmisToKeep;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public ServerReplicationParameters build() {
            return new ServerReplicationParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
