/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReplicationRunsResponse extends SmsResponse implements
        ToCopyableBuilder<GetReplicationRunsResponse.Builder, GetReplicationRunsResponse> {
    private static final SdkField<ReplicationJob> REPLICATION_JOB_FIELD = SdkField
            .<ReplicationJob> builder(MarshallingType.SDK_POJO).getter(getter(GetReplicationRunsResponse::replicationJob))
            .setter(setter(Builder::replicationJob)).constructor(ReplicationJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationJob").build()).build();

    private static final SdkField<List<ReplicationRun>> REPLICATION_RUN_LIST_FIELD = SdkField
            .<List<ReplicationRun>> builder(MarshallingType.LIST)
            .getter(getter(GetReplicationRunsResponse::replicationRunList))
            .setter(setter(Builder::replicationRunList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationRunList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetReplicationRunsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_JOB_FIELD,
            REPLICATION_RUN_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final ReplicationJob replicationJob;

    private final List<ReplicationRun> replicationRunList;

    private final String nextToken;

    private GetReplicationRunsResponse(BuilderImpl builder) {
        super(builder);
        this.replicationJob = builder.replicationJob;
        this.replicationRunList = builder.replicationRunList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the replication job.
     * </p>
     * 
     * @return Information about the replication job.
     */
    public ReplicationJob replicationJob() {
        return replicationJob;
    }

    /**
     * Returns true if the ReplicationRunList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReplicationRunList() {
        return replicationRunList != null && !(replicationRunList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the replication runs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicationRunList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the replication runs.
     */
    public List<ReplicationRun> replicationRunList() {
        return replicationRunList;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is null when there are no more results
     *         to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationJob());
        hashCode = 31 * hashCode + Objects.hashCode(replicationRunList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReplicationRunsResponse)) {
            return false;
        }
        GetReplicationRunsResponse other = (GetReplicationRunsResponse) obj;
        return Objects.equals(replicationJob(), other.replicationJob())
                && Objects.equals(replicationRunList(), other.replicationRunList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetReplicationRunsResponse").add("ReplicationJob", replicationJob())
                .add("ReplicationRunList", replicationRunList()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replicationJob":
            return Optional.ofNullable(clazz.cast(replicationJob()));
        case "replicationRunList":
            return Optional.ofNullable(clazz.cast(replicationRunList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReplicationRunsResponse, T> g) {
        return obj -> g.apply((GetReplicationRunsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetReplicationRunsResponse> {
        /**
         * <p>
         * Information about the replication job.
         * </p>
         * 
         * @param replicationJob
         *        Information about the replication job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationJob(ReplicationJob replicationJob);

        /**
         * <p>
         * Information about the replication job.
         * </p>
         * This is a convenience that creates an instance of the {@link ReplicationJob.Builder} avoiding the need to
         * create one manually via {@link ReplicationJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReplicationJob.Builder#build()} is called immediately and its
         * result is passed to {@link #replicationJob(ReplicationJob)}.
         * 
         * @param replicationJob
         *        a consumer that will call methods on {@link ReplicationJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationJob(ReplicationJob)
         */
        default Builder replicationJob(Consumer<ReplicationJob.Builder> replicationJob) {
            return replicationJob(ReplicationJob.builder().applyMutation(replicationJob).build());
        }

        /**
         * <p>
         * Information about the replication runs.
         * </p>
         * 
         * @param replicationRunList
         *        Information about the replication runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationRunList(Collection<ReplicationRun> replicationRunList);

        /**
         * <p>
         * Information about the replication runs.
         * </p>
         * 
         * @param replicationRunList
         *        Information about the replication runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationRunList(ReplicationRun... replicationRunList);

        /**
         * <p>
         * Information about the replication runs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicationRun>.Builder} avoiding the need
         * to create one manually via {@link List<ReplicationRun>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationRun>.Builder#build()} is called immediately and
         * its result is passed to {@link #replicationRunList(List<ReplicationRun>)}.
         * 
         * @param replicationRunList
         *        a consumer that will call methods on {@link List<ReplicationRun>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationRunList(List<ReplicationRun>)
         */
        Builder replicationRunList(Consumer<ReplicationRun.Builder>... replicationRunList);

        /**
         * <p>
         * The token required to retrieve the next set of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SmsResponse.BuilderImpl implements Builder {
        private ReplicationJob replicationJob;

        private List<ReplicationRun> replicationRunList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReplicationRunsResponse model) {
            super(model);
            replicationJob(model.replicationJob);
            replicationRunList(model.replicationRunList);
            nextToken(model.nextToken);
        }

        public final ReplicationJob.Builder getReplicationJob() {
            return replicationJob != null ? replicationJob.toBuilder() : null;
        }

        @Override
        public final Builder replicationJob(ReplicationJob replicationJob) {
            this.replicationJob = replicationJob;
            return this;
        }

        public final void setReplicationJob(ReplicationJob.BuilderImpl replicationJob) {
            this.replicationJob = replicationJob != null ? replicationJob.build() : null;
        }

        public final Collection<ReplicationRun.Builder> getReplicationRunList() {
            return replicationRunList != null ? replicationRunList.stream().map(ReplicationRun::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationRunList(Collection<ReplicationRun> replicationRunList) {
            this.replicationRunList = ReplicationRunListCopier.copy(replicationRunList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRunList(ReplicationRun... replicationRunList) {
            replicationRunList(Arrays.asList(replicationRunList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRunList(Consumer<ReplicationRun.Builder>... replicationRunList) {
            replicationRunList(Stream.of(replicationRunList).map(c -> ReplicationRun.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationRunList(Collection<ReplicationRun.BuilderImpl> replicationRunList) {
            this.replicationRunList = ReplicationRunListCopier.copyFromBuilder(replicationRunList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetReplicationRunsResponse build() {
            return new GetReplicationRunsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
