/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReplicationJobsResponse extends SmsResponse implements
        ToCopyableBuilder<GetReplicationJobsResponse.Builder, GetReplicationJobsResponse> {
    private static final SdkField<List<ReplicationJob>> REPLICATION_JOB_LIST_FIELD = SdkField
            .<List<ReplicationJob>> builder(MarshallingType.LIST)
            .getter(getter(GetReplicationJobsResponse::replicationJobList))
            .setter(setter(Builder::replicationJobList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationJobList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetReplicationJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_JOB_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ReplicationJob> replicationJobList;

    private final String nextToken;

    private GetReplicationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.replicationJobList = builder.replicationJobList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ReplicationJobList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReplicationJobList() {
        return replicationJobList != null && !(replicationJobList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the replication jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicationJobList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the replication jobs.
     */
    public List<ReplicationJob> replicationJobList() {
        return replicationJobList;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is null when there are no more results
     *         to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationJobList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReplicationJobsResponse)) {
            return false;
        }
        GetReplicationJobsResponse other = (GetReplicationJobsResponse) obj;
        return Objects.equals(replicationJobList(), other.replicationJobList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetReplicationJobsResponse").add("ReplicationJobList", replicationJobList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replicationJobList":
            return Optional.ofNullable(clazz.cast(replicationJobList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReplicationJobsResponse, T> g) {
        return obj -> g.apply((GetReplicationJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetReplicationJobsResponse> {
        /**
         * <p>
         * Information about the replication jobs.
         * </p>
         * 
         * @param replicationJobList
         *        Information about the replication jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationJobList(Collection<ReplicationJob> replicationJobList);

        /**
         * <p>
         * Information about the replication jobs.
         * </p>
         * 
         * @param replicationJobList
         *        Information about the replication jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationJobList(ReplicationJob... replicationJobList);

        /**
         * <p>
         * Information about the replication jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicationJob>.Builder} avoiding the need
         * to create one manually via {@link List<ReplicationJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationJob>.Builder#build()} is called immediately and
         * its result is passed to {@link #replicationJobList(List<ReplicationJob>)}.
         * 
         * @param replicationJobList
         *        a consumer that will call methods on {@link List<ReplicationJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationJobList(List<ReplicationJob>)
         */
        Builder replicationJobList(Consumer<ReplicationJob.Builder>... replicationJobList);

        /**
         * <p>
         * The token required to retrieve the next set of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SmsResponse.BuilderImpl implements Builder {
        private List<ReplicationJob> replicationJobList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReplicationJobsResponse model) {
            super(model);
            replicationJobList(model.replicationJobList);
            nextToken(model.nextToken);
        }

        public final Collection<ReplicationJob.Builder> getReplicationJobList() {
            return replicationJobList != null ? replicationJobList.stream().map(ReplicationJob::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationJobList(Collection<ReplicationJob> replicationJobList) {
            this.replicationJobList = ReplicationJobListCopier.copy(replicationJobList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationJobList(ReplicationJob... replicationJobList) {
            replicationJobList(Arrays.asList(replicationJobList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationJobList(Consumer<ReplicationJob.Builder>... replicationJobList) {
            replicationJobList(Stream.of(replicationJobList).map(c -> ReplicationJob.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationJobList(Collection<ReplicationJob.BuilderImpl> replicationJobList) {
            this.replicationJobList = ReplicationJobListCopier.copyFromBuilder(replicationJobList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetReplicationJobsResponse build() {
            return new GetReplicationJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
