/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAppRequest extends SmsRequest implements ToCopyableBuilder<DeleteAppRequest.Builder, DeleteAppRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteAppRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<Boolean> FORCE_STOP_APP_REPLICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteAppRequest::forceStopAppReplication)).setter(setter(Builder::forceStopAppReplication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceStopAppReplication").build())
            .build();

    private static final SdkField<Boolean> FORCE_TERMINATE_APP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteAppRequest::forceTerminateApp)).setter(setter(Builder::forceTerminateApp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceTerminateApp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            FORCE_STOP_APP_REPLICATION_FIELD, FORCE_TERMINATE_APP_FIELD));

    private final String appId;

    private final Boolean forceStopAppReplication;

    private final Boolean forceTerminateApp;

    private DeleteAppRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.forceStopAppReplication = builder.forceStopAppReplication;
        this.forceTerminateApp = builder.forceTerminateApp;
    }

    /**
     * <p>
     * ID of the application to delete.
     * </p>
     * 
     * @return ID of the application to delete.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * While deleting the application, stop all replication jobs corresponding to the servers in the application.
     * </p>
     * 
     * @return While deleting the application, stop all replication jobs corresponding to the servers in the
     *         application.
     */
    public Boolean forceStopAppReplication() {
        return forceStopAppReplication;
    }

    /**
     * <p>
     * While deleting the application, terminate the stack corresponding to the application.
     * </p>
     * 
     * @return While deleting the application, terminate the stack corresponding to the application.
     */
    public Boolean forceTerminateApp() {
        return forceTerminateApp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(forceStopAppReplication());
        hashCode = 31 * hashCode + Objects.hashCode(forceTerminateApp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAppRequest)) {
            return false;
        }
        DeleteAppRequest other = (DeleteAppRequest) obj;
        return Objects.equals(appId(), other.appId())
                && Objects.equals(forceStopAppReplication(), other.forceStopAppReplication())
                && Objects.equals(forceTerminateApp(), other.forceTerminateApp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteAppRequest").add("AppId", appId())
                .add("ForceStopAppReplication", forceStopAppReplication()).add("ForceTerminateApp", forceTerminateApp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "forceStopAppReplication":
            return Optional.ofNullable(clazz.cast(forceStopAppReplication()));
        case "forceTerminateApp":
            return Optional.ofNullable(clazz.cast(forceTerminateApp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAppRequest, T> g) {
        return obj -> g.apply((DeleteAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAppRequest> {
        /**
         * <p>
         * ID of the application to delete.
         * </p>
         * 
         * @param appId
         *        ID of the application to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * While deleting the application, stop all replication jobs corresponding to the servers in the application.
         * </p>
         * 
         * @param forceStopAppReplication
         *        While deleting the application, stop all replication jobs corresponding to the servers in the
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceStopAppReplication(Boolean forceStopAppReplication);

        /**
         * <p>
         * While deleting the application, terminate the stack corresponding to the application.
         * </p>
         * 
         * @param forceTerminateApp
         *        While deleting the application, terminate the stack corresponding to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceTerminateApp(Boolean forceTerminateApp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SmsRequest.BuilderImpl implements Builder {
        private String appId;

        private Boolean forceStopAppReplication;

        private Boolean forceTerminateApp;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAppRequest model) {
            super(model);
            appId(model.appId);
            forceStopAppReplication(model.forceStopAppReplication);
            forceTerminateApp(model.forceTerminateApp);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final Boolean getForceStopAppReplication() {
            return forceStopAppReplication;
        }

        @Override
        public final Builder forceStopAppReplication(Boolean forceStopAppReplication) {
            this.forceStopAppReplication = forceStopAppReplication;
            return this;
        }

        public final void setForceStopAppReplication(Boolean forceStopAppReplication) {
            this.forceStopAppReplication = forceStopAppReplication;
        }

        public final Boolean getForceTerminateApp() {
            return forceTerminateApp;
        }

        @Override
        public final Builder forceTerminateApp(Boolean forceTerminateApp) {
            this.forceTerminateApp = forceTerminateApp;
            return this;
        }

        public final void setForceTerminateApp(Boolean forceTerminateApp) {
            this.forceTerminateApp = forceTerminateApp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAppRequest build() {
            return new DeleteAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
