/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppSummary implements SdkPojo, Serializable, ToCopyableBuilder<AppSummary.Builder, AppSummary> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppSummary::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppSummary::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> REPLICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppSummary::replicationStatusAsString)).setter(setter(Builder::replicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStatus").build()).build();

    private static final SdkField<String> REPLICATION_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppSummary::replicationStatusMessage)).setter(setter(Builder::replicationStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStatusMessage").build())
            .build();

    private static final SdkField<Instant> LATEST_REPLICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AppSummary::latestReplicationTime)).setter(setter(Builder::latestReplicationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestReplicationTime").build())
            .build();

    private static final SdkField<String> LAUNCH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppSummary::launchStatusAsString)).setter(setter(Builder::launchStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchStatus").build()).build();

    private static final SdkField<String> LAUNCH_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppSummary::launchStatusMessage)).setter(setter(Builder::launchStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchStatusMessage").build())
            .build();

    private static final SdkField<LaunchDetails> LAUNCH_DETAILS_FIELD = SdkField
            .<LaunchDetails> builder(MarshallingType.SDK_POJO).getter(getter(AppSummary::launchDetails))
            .setter(setter(Builder::launchDetails)).constructor(LaunchDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDetails").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AppSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AppSummary::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AppSummary::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()).build();

    private static final SdkField<Integer> TOTAL_SERVER_GROUPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AppSummary::totalServerGroups)).setter(setter(Builder::totalServerGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalServerGroups").build()).build();

    private static final SdkField<Integer> TOTAL_SERVERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AppSummary::totalServers)).setter(setter(Builder::totalServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalServers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, REPLICATION_STATUS_FIELD, REPLICATION_STATUS_MESSAGE_FIELD,
            LATEST_REPLICATION_TIME_FIELD, LAUNCH_STATUS_FIELD, LAUNCH_STATUS_MESSAGE_FIELD, LAUNCH_DETAILS_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_FIELD, ROLE_NAME_FIELD, TOTAL_SERVER_GROUPS_FIELD, TOTAL_SERVERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appId;

    private final String name;

    private final String description;

    private final String status;

    private final String statusMessage;

    private final String replicationStatus;

    private final String replicationStatusMessage;

    private final Instant latestReplicationTime;

    private final String launchStatus;

    private final String launchStatusMessage;

    private final LaunchDetails launchDetails;

    private final Instant creationTime;

    private final Instant lastModified;

    private final String roleName;

    private final Integer totalServerGroups;

    private final Integer totalServers;

    private AppSummary(BuilderImpl builder) {
        this.appId = builder.appId;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.replicationStatus = builder.replicationStatus;
        this.replicationStatusMessage = builder.replicationStatusMessage;
        this.latestReplicationTime = builder.latestReplicationTime;
        this.launchStatus = builder.launchStatus;
        this.launchStatusMessage = builder.launchStatusMessage;
        this.launchDetails = builder.launchDetails;
        this.creationTime = builder.creationTime;
        this.lastModified = builder.lastModified;
        this.roleName = builder.roleName;
        this.totalServerGroups = builder.totalServerGroups;
        this.totalServers = builder.totalServers;
    }

    /**
     * <p>
     * Unique ID of the application.
     * </p>
     * 
     * @return Unique ID of the application.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * Name of the application.
     * </p>
     * 
     * @return Name of the application.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Description of the application.
     * </p>
     * 
     * @return Description of the application.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the application.
     * @see AppStatus
     */
    public AppStatus status() {
        return AppStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the application.
     * @see AppStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message related to the status of the application
     * </p>
     * 
     * @return A message related to the status of the application
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Replication status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationStatus}
     * will return {@link AppReplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #replicationStatusAsString}.
     * </p>
     * 
     * @return Replication status of the application.
     * @see AppReplicationStatus
     */
    public AppReplicationStatus replicationStatus() {
        return AppReplicationStatus.fromValue(replicationStatus);
    }

    /**
     * <p>
     * Replication status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationStatus}
     * will return {@link AppReplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #replicationStatusAsString}.
     * </p>
     * 
     * @return Replication status of the application.
     * @see AppReplicationStatus
     */
    public String replicationStatusAsString() {
        return replicationStatus;
    }

    /**
     * <p>
     * A message related to the replication status of the application.
     * </p>
     * 
     * @return A message related to the replication status of the application.
     */
    public String replicationStatusMessage() {
        return replicationStatusMessage;
    }

    /**
     * <p>
     * Timestamp of the application's most recent successful replication.
     * </p>
     * 
     * @return Timestamp of the application's most recent successful replication.
     */
    public Instant latestReplicationTime() {
        return latestReplicationTime;
    }

    /**
     * <p>
     * Launch status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchStatus} will
     * return {@link AppLaunchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchStatusAsString}.
     * </p>
     * 
     * @return Launch status of the application.
     * @see AppLaunchStatus
     */
    public AppLaunchStatus launchStatus() {
        return AppLaunchStatus.fromValue(launchStatus);
    }

    /**
     * <p>
     * Launch status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchStatus} will
     * return {@link AppLaunchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchStatusAsString}.
     * </p>
     * 
     * @return Launch status of the application.
     * @see AppLaunchStatus
     */
    public String launchStatusAsString() {
        return launchStatus;
    }

    /**
     * <p>
     * A message related to the launch status of the application.
     * </p>
     * 
     * @return A message related to the launch status of the application.
     */
    public String launchStatusMessage() {
        return launchStatusMessage;
    }

    /**
     * <p>
     * Details about the latest launch of the application.
     * </p>
     * 
     * @return Details about the latest launch of the application.
     */
    public LaunchDetails launchDetails() {
        return launchDetails;
    }

    /**
     * <p>
     * Time of creation of this application.
     * </p>
     * 
     * @return Time of creation of this application.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Timestamp of the application's creation.
     * </p>
     * 
     * @return Timestamp of the application's creation.
     */
    public Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * Name of the service role in the customer's account used by AWS SMS.
     * </p>
     * 
     * @return Name of the service role in the customer's account used by AWS SMS.
     */
    public String roleName() {
        return roleName;
    }

    /**
     * <p>
     * Number of server groups present in the application.
     * </p>
     * 
     * @return Number of server groups present in the application.
     */
    public Integer totalServerGroups() {
        return totalServerGroups;
    }

    /**
     * <p>
     * Number of servers present in the application.
     * </p>
     * 
     * @return Number of servers present in the application.
     */
    public Integer totalServers() {
        return totalServers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(replicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicationStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(latestReplicationTime());
        hashCode = 31 * hashCode + Objects.hashCode(launchStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(launchStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(launchDetails());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(totalServerGroups());
        hashCode = 31 * hashCode + Objects.hashCode(totalServers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppSummary)) {
            return false;
        }
        AppSummary other = (AppSummary) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(replicationStatusAsString(), other.replicationStatusAsString())
                && Objects.equals(replicationStatusMessage(), other.replicationStatusMessage())
                && Objects.equals(latestReplicationTime(), other.latestReplicationTime())
                && Objects.equals(launchStatusAsString(), other.launchStatusAsString())
                && Objects.equals(launchStatusMessage(), other.launchStatusMessage())
                && Objects.equals(launchDetails(), other.launchDetails()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModified(), other.lastModified()) && Objects.equals(roleName(), other.roleName())
                && Objects.equals(totalServerGroups(), other.totalServerGroups())
                && Objects.equals(totalServers(), other.totalServers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AppSummary").add("AppId", appId()).add("Name", name()).add("Description", description())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("ReplicationStatus", replicationStatusAsString())
                .add("ReplicationStatusMessage", replicationStatusMessage())
                .add("LatestReplicationTime", latestReplicationTime()).add("LaunchStatus", launchStatusAsString())
                .add("LaunchStatusMessage", launchStatusMessage()).add("LaunchDetails", launchDetails())
                .add("CreationTime", creationTime()).add("LastModified", lastModified()).add("RoleName", roleName())
                .add("TotalServerGroups", totalServerGroups()).add("TotalServers", totalServers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "replicationStatus":
            return Optional.ofNullable(clazz.cast(replicationStatusAsString()));
        case "replicationStatusMessage":
            return Optional.ofNullable(clazz.cast(replicationStatusMessage()));
        case "latestReplicationTime":
            return Optional.ofNullable(clazz.cast(latestReplicationTime()));
        case "launchStatus":
            return Optional.ofNullable(clazz.cast(launchStatusAsString()));
        case "launchStatusMessage":
            return Optional.ofNullable(clazz.cast(launchStatusMessage()));
        case "launchDetails":
            return Optional.ofNullable(clazz.cast(launchDetails()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "roleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "totalServerGroups":
            return Optional.ofNullable(clazz.cast(totalServerGroups()));
        case "totalServers":
            return Optional.ofNullable(clazz.cast(totalServers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppSummary, T> g) {
        return obj -> g.apply((AppSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppSummary> {
        /**
         * <p>
         * Unique ID of the application.
         * </p>
         * 
         * @param appId
         *        Unique ID of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * Name of the application.
         * </p>
         * 
         * @param name
         *        Name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description of the application.
         * </p>
         * 
         * @param description
         *        Description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Status of the application.
         * </p>
         * 
         * @param status
         *        Status of the application.
         * @see AppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the application.
         * </p>
         * 
         * @param status
         *        Status of the application.
         * @see AppStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatus
         */
        Builder status(AppStatus status);

        /**
         * <p>
         * A message related to the status of the application
         * </p>
         * 
         * @param statusMessage
         *        A message related to the status of the application
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Replication status of the application.
         * </p>
         * 
         * @param replicationStatus
         *        Replication status of the application.
         * @see AppReplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppReplicationStatus
         */
        Builder replicationStatus(String replicationStatus);

        /**
         * <p>
         * Replication status of the application.
         * </p>
         * 
         * @param replicationStatus
         *        Replication status of the application.
         * @see AppReplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppReplicationStatus
         */
        Builder replicationStatus(AppReplicationStatus replicationStatus);

        /**
         * <p>
         * A message related to the replication status of the application.
         * </p>
         * 
         * @param replicationStatusMessage
         *        A message related to the replication status of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatusMessage(String replicationStatusMessage);

        /**
         * <p>
         * Timestamp of the application's most recent successful replication.
         * </p>
         * 
         * @param latestReplicationTime
         *        Timestamp of the application's most recent successful replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestReplicationTime(Instant latestReplicationTime);

        /**
         * <p>
         * Launch status of the application.
         * </p>
         * 
         * @param launchStatus
         *        Launch status of the application.
         * @see AppLaunchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppLaunchStatus
         */
        Builder launchStatus(String launchStatus);

        /**
         * <p>
         * Launch status of the application.
         * </p>
         * 
         * @param launchStatus
         *        Launch status of the application.
         * @see AppLaunchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppLaunchStatus
         */
        Builder launchStatus(AppLaunchStatus launchStatus);

        /**
         * <p>
         * A message related to the launch status of the application.
         * </p>
         * 
         * @param launchStatusMessage
         *        A message related to the launch status of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchStatusMessage(String launchStatusMessage);

        /**
         * <p>
         * Details about the latest launch of the application.
         * </p>
         * 
         * @param launchDetails
         *        Details about the latest launch of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchDetails(LaunchDetails launchDetails);

        /**
         * <p>
         * Details about the latest launch of the application.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchDetails.Builder} avoiding the need to
         * create one manually via {@link LaunchDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #launchDetails(LaunchDetails)}.
         * 
         * @param launchDetails
         *        a consumer that will call methods on {@link LaunchDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchDetails(LaunchDetails)
         */
        default Builder launchDetails(Consumer<LaunchDetails.Builder> launchDetails) {
            return launchDetails(LaunchDetails.builder().applyMutation(launchDetails).build());
        }

        /**
         * <p>
         * Time of creation of this application.
         * </p>
         * 
         * @param creationTime
         *        Time of creation of this application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Timestamp of the application's creation.
         * </p>
         * 
         * @param lastModified
         *        Timestamp of the application's creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * Name of the service role in the customer's account used by AWS SMS.
         * </p>
         * 
         * @param roleName
         *        Name of the service role in the customer's account used by AWS SMS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * Number of server groups present in the application.
         * </p>
         * 
         * @param totalServerGroups
         *        Number of server groups present in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalServerGroups(Integer totalServerGroups);

        /**
         * <p>
         * Number of servers present in the application.
         * </p>
         * 
         * @param totalServers
         *        Number of servers present in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalServers(Integer totalServers);
    }

    static final class BuilderImpl implements Builder {
        private String appId;

        private String name;

        private String description;

        private String status;

        private String statusMessage;

        private String replicationStatus;

        private String replicationStatusMessage;

        private Instant latestReplicationTime;

        private String launchStatus;

        private String launchStatusMessage;

        private LaunchDetails launchDetails;

        private Instant creationTime;

        private Instant lastModified;

        private String roleName;

        private Integer totalServerGroups;

        private Integer totalServers;

        private BuilderImpl() {
        }

        private BuilderImpl(AppSummary model) {
            appId(model.appId);
            name(model.name);
            description(model.description);
            status(model.status);
            statusMessage(model.statusMessage);
            replicationStatus(model.replicationStatus);
            replicationStatusMessage(model.replicationStatusMessage);
            latestReplicationTime(model.latestReplicationTime);
            launchStatus(model.launchStatus);
            launchStatusMessage(model.launchStatusMessage);
            launchDetails(model.launchDetails);
            creationTime(model.creationTime);
            lastModified(model.lastModified);
            roleName(model.roleName);
            totalServerGroups(model.totalServerGroups);
            totalServers(model.totalServers);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getReplicationStatusAsString() {
            return replicationStatus;
        }

        @Override
        public final Builder replicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
            return this;
        }

        @Override
        public final Builder replicationStatus(AppReplicationStatus replicationStatus) {
            this.replicationStatus(replicationStatus == null ? null : replicationStatus.toString());
            return this;
        }

        public final void setReplicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
        }

        public final String getReplicationStatusMessage() {
            return replicationStatusMessage;
        }

        @Override
        public final Builder replicationStatusMessage(String replicationStatusMessage) {
            this.replicationStatusMessage = replicationStatusMessage;
            return this;
        }

        public final void setReplicationStatusMessage(String replicationStatusMessage) {
            this.replicationStatusMessage = replicationStatusMessage;
        }

        public final Instant getLatestReplicationTime() {
            return latestReplicationTime;
        }

        @Override
        public final Builder latestReplicationTime(Instant latestReplicationTime) {
            this.latestReplicationTime = latestReplicationTime;
            return this;
        }

        public final void setLatestReplicationTime(Instant latestReplicationTime) {
            this.latestReplicationTime = latestReplicationTime;
        }

        public final String getLaunchStatusAsString() {
            return launchStatus;
        }

        @Override
        public final Builder launchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
            return this;
        }

        @Override
        public final Builder launchStatus(AppLaunchStatus launchStatus) {
            this.launchStatus(launchStatus == null ? null : launchStatus.toString());
            return this;
        }

        public final void setLaunchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
        }

        public final String getLaunchStatusMessage() {
            return launchStatusMessage;
        }

        @Override
        public final Builder launchStatusMessage(String launchStatusMessage) {
            this.launchStatusMessage = launchStatusMessage;
            return this;
        }

        public final void setLaunchStatusMessage(String launchStatusMessage) {
            this.launchStatusMessage = launchStatusMessage;
        }

        public final LaunchDetails.Builder getLaunchDetails() {
            return launchDetails != null ? launchDetails.toBuilder() : null;
        }

        @Override
        public final Builder launchDetails(LaunchDetails launchDetails) {
            this.launchDetails = launchDetails;
            return this;
        }

        public final void setLaunchDetails(LaunchDetails.BuilderImpl launchDetails) {
            this.launchDetails = launchDetails != null ? launchDetails.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final Integer getTotalServerGroups() {
            return totalServerGroups;
        }

        @Override
        public final Builder totalServerGroups(Integer totalServerGroups) {
            this.totalServerGroups = totalServerGroups;
            return this;
        }

        public final void setTotalServerGroups(Integer totalServerGroups) {
            this.totalServerGroups = totalServerGroups;
        }

        public final Integer getTotalServers() {
            return totalServers;
        }

        @Override
        public final Builder totalServers(Integer totalServers) {
            this.totalServers = totalServers;
            return this;
        }

        public final void setTotalServers(Integer totalServers) {
            this.totalServers = totalServers;
        }

        @Override
        public AppSummary build() {
            return new AppSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
