/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sms.model.VmServer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VmServerMarshaller {
    private static final MarshallingInfo<StructuredPojo> VMSERVERADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmServerAddress").isBinary(false).build();
    private static final MarshallingInfo<String> VMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmName").isBinary(false).build();
    private static final MarshallingInfo<String> VMMANAGERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmManagerName").isBinary(false).build();
    private static final MarshallingInfo<String> VMMANAGERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmManagerType").isBinary(false).build();
    private static final MarshallingInfo<String> VMPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmPath").isBinary(false).build();
    private static final VmServerMarshaller INSTANCE = new VmServerMarshaller();

    private VmServerMarshaller() {
    }

    public static VmServerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VmServer vmServer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)vmServer, (String)"vmServer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)vmServer.vmServerAddress(), VMSERVERADDRESS_BINDING);
            protocolMarshaller.marshall((Object)vmServer.vmName(), VMNAME_BINDING);
            protocolMarshaller.marshall((Object)vmServer.vmManagerName(), VMMANAGERNAME_BINDING);
            protocolMarshaller.marshall((Object)vmServer.vmManagerTypeAsString(), VMMANAGERTYPE_BINDING);
            protocolMarshaller.marshall((Object)vmServer.vmPath(), VMPATH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

