/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sms.model.VmServerAddress;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VmServerAddressMarshaller {
    private static final MarshallingInfo<String> VMMANAGERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmManagerId").isBinary(false).build();
    private static final MarshallingInfo<String> VMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmId").isBinary(false).build();
    private static final VmServerAddressMarshaller INSTANCE = new VmServerAddressMarshaller();

    private VmServerAddressMarshaller() {
    }

    public static VmServerAddressMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VmServerAddress vmServerAddress, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)vmServerAddress, (String)"vmServerAddress");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)vmServerAddress.vmManagerId(), VMMANAGERID_BINDING);
            protocolMarshaller.marshall((Object)vmServerAddress.vmId(), VMID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

