/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sms.model.ReplicationRun;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplicationRunMarshaller {
    private static final MarshallingInfo<String> REPLICATIONRUNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationRunId").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusMessage").isBinary(false).build();
    private static final MarshallingInfo<String> AMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amiId").isBinary(false).build();
    private static final MarshallingInfo<Instant> SCHEDULEDSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scheduledStartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> COMPLETEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("completedTime").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final ReplicationRunMarshaller INSTANCE = new ReplicationRunMarshaller();

    private ReplicationRunMarshaller() {
    }

    public static ReplicationRunMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReplicationRun replicationRun, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)replicationRun, (String)"replicationRun");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replicationRun.replicationRunId(), REPLICATIONRUNID_BINDING);
            protocolMarshaller.marshall((Object)replicationRun.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)replicationRun.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)replicationRun.statusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)replicationRun.amiId(), AMIID_BINDING);
            protocolMarshaller.marshall((Object)replicationRun.scheduledStartTime(), SCHEDULEDSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)replicationRun.completedTime(), COMPLETEDTIME_BINDING);
            protocolMarshaller.marshall((Object)replicationRun.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

