/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.sms.model.Connector;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConnectorMarshaller {
    private static final MarshallingInfo<String> CONNECTORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectorId").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<List> CAPABILITYLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("capabilityList").isBinary(false).build();
    private static final MarshallingInfo<String> VMMANAGERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmManagerName").isBinary(false).build();
    private static final MarshallingInfo<String> VMMANAGERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmManagerType").isBinary(false).build();
    private static final MarshallingInfo<String> VMMANAGERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmManagerId").isBinary(false).build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipAddress").isBinary(false).build();
    private static final MarshallingInfo<String> MACADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("macAddress").isBinary(false).build();
    private static final MarshallingInfo<Instant> ASSOCIATEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("associatedOn").isBinary(false).build();
    private static final ConnectorMarshaller INSTANCE = new ConnectorMarshaller();

    private ConnectorMarshaller() {
    }

    public static ConnectorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Connector connector, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)connector, (String)"connector");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)connector.connectorId(), CONNECTORID_BINDING);
            protocolMarshaller.marshall((Object)connector.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)connector.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(connector.capabilityListAsStrings(), CAPABILITYLIST_BINDING);
            protocolMarshaller.marshall((Object)connector.vmManagerName(), VMMANAGERNAME_BINDING);
            protocolMarshaller.marshall((Object)connector.vmManagerTypeAsString(), VMMANAGERTYPE_BINDING);
            protocolMarshaller.marshall((Object)connector.vmManagerId(), VMMANAGERID_BINDING);
            protocolMarshaller.marshall((Object)connector.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)connector.macAddress(), MACADDRESS_BINDING);
            protocolMarshaller.marshall((Object)connector.associatedOn(), ASSOCIATEDON_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

