/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.simspaceweaver.model.LaunchOverrides;
import software.amazon.awssdk.services.simspaceweaver.model.SimSpaceWeaverResponse;
import software.amazon.awssdk.services.simspaceweaver.model.SimulationAppEndpointInfo;
import software.amazon.awssdk.services.simspaceweaver.model.SimulationAppStatus;
import software.amazon.awssdk.services.simspaceweaver.model.SimulationAppTargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAppResponse
extends SimSpaceWeaverResponse
implements ToCopyableBuilder<Builder, DescribeAppResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeAppResponse.getter(DescribeAppResponse::description)).setter(DescribeAppResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(DescribeAppResponse.getter(DescribeAppResponse::domain)).setter(DescribeAppResponse.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<SimulationAppEndpointInfo> ENDPOINT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointInfo").getter(DescribeAppResponse.getter(DescribeAppResponse::endpointInfo)).setter(DescribeAppResponse.setter(Builder::endpointInfo)).constructor(SimulationAppEndpointInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointInfo").build()}).build();
    private static final SdkField<LaunchOverrides> LAUNCH_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchOverrides").getter(DescribeAppResponse.getter(DescribeAppResponse::launchOverrides)).setter(DescribeAppResponse.setter(Builder::launchOverrides)).constructor(LaunchOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchOverrides").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeAppResponse.getter(DescribeAppResponse::name)).setter(DescribeAppResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SIMULATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Simulation").getter(DescribeAppResponse.getter(DescribeAppResponse::simulation)).setter(DescribeAppResponse.setter(Builder::simulation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Simulation").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeAppResponse.getter(DescribeAppResponse::statusAsString)).setter(DescribeAppResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetStatus").getter(DescribeAppResponse.getter(DescribeAppResponse::targetStatusAsString)).setter(DescribeAppResponse.setter(Builder::targetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DOMAIN_FIELD, ENDPOINT_INFO_FIELD, LAUNCH_OVERRIDES_FIELD, NAME_FIELD, SIMULATION_FIELD, STATUS_FIELD, TARGET_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAppResponse.memberNameToFieldInitializer();
    private final String description;
    private final String domain;
    private final SimulationAppEndpointInfo endpointInfo;
    private final LaunchOverrides launchOverrides;
    private final String name;
    private final String simulation;
    private final String status;
    private final String targetStatus;

    private DescribeAppResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domain = builder.domain;
        this.endpointInfo = builder.endpointInfo;
        this.launchOverrides = builder.launchOverrides;
        this.name = builder.name;
        this.simulation = builder.simulation;
        this.status = builder.status;
        this.targetStatus = builder.targetStatus;
    }

    public final String description() {
        return this.description;
    }

    public final String domain() {
        return this.domain;
    }

    public final SimulationAppEndpointInfo endpointInfo() {
        return this.endpointInfo;
    }

    public final LaunchOverrides launchOverrides() {
        return this.launchOverrides;
    }

    public final String name() {
        return this.name;
    }

    public final String simulation() {
        return this.simulation;
    }

    public final SimulationAppStatus status() {
        return SimulationAppStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final SimulationAppTargetStatus targetStatus() {
        return SimulationAppTargetStatus.fromValue(this.targetStatus);
    }

    public final String targetStatusAsString() {
        return this.targetStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.simulation());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppResponse)) {
            return false;
        }
        DescribeAppResponse other = (DescribeAppResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.endpointInfo(), other.endpointInfo()) && Objects.equals(this.launchOverrides(), other.launchOverrides()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.simulation(), other.simulation()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetStatusAsString(), other.targetStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAppResponse").add("Description", (Object)this.description()).add("Domain", (Object)this.domain()).add("EndpointInfo", (Object)this.endpointInfo()).add("LaunchOverrides", (Object)this.launchOverrides()).add("Name", (Object)this.name()).add("Simulation", (Object)this.simulation()).add("Status", (Object)this.statusAsString()).add("TargetStatus", (Object)this.targetStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "EndpointInfo": {
                return Optional.ofNullable(clazz.cast(this.endpointInfo()));
            }
            case "LaunchOverrides": {
                return Optional.ofNullable(clazz.cast(this.launchOverrides()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Simulation": {
                return Optional.ofNullable(clazz.cast(this.simulation()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TargetStatus": {
                return Optional.ofNullable(clazz.cast(this.targetStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("EndpointInfo", ENDPOINT_INFO_FIELD);
        map.put("LaunchOverrides", LAUNCH_OVERRIDES_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Simulation", SIMULATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TargetStatus", TARGET_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppResponse, T> g) {
        return obj -> g.apply((DescribeAppResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SimSpaceWeaverResponse.BuilderImpl
    implements Builder {
        private String description;
        private String domain;
        private SimulationAppEndpointInfo endpointInfo;
        private LaunchOverrides launchOverrides;
        private String name;
        private String simulation;
        private String status;
        private String targetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppResponse model) {
            super(model);
            this.description(model.description);
            this.domain(model.domain);
            this.endpointInfo(model.endpointInfo);
            this.launchOverrides(model.launchOverrides);
            this.name(model.name);
            this.simulation(model.simulation);
            this.status(model.status);
            this.targetStatus(model.targetStatus);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final SimulationAppEndpointInfo.Builder getEndpointInfo() {
            return this.endpointInfo != null ? this.endpointInfo.toBuilder() : null;
        }

        public final void setEndpointInfo(SimulationAppEndpointInfo.BuilderImpl endpointInfo) {
            this.endpointInfo = endpointInfo != null ? endpointInfo.build() : null;
        }

        @Override
        public final Builder endpointInfo(SimulationAppEndpointInfo endpointInfo) {
            this.endpointInfo = endpointInfo;
            return this;
        }

        public final LaunchOverrides.Builder getLaunchOverrides() {
            return this.launchOverrides != null ? this.launchOverrides.toBuilder() : null;
        }

        public final void setLaunchOverrides(LaunchOverrides.BuilderImpl launchOverrides) {
            this.launchOverrides = launchOverrides != null ? launchOverrides.build() : null;
        }

        @Override
        public final Builder launchOverrides(LaunchOverrides launchOverrides) {
            this.launchOverrides = launchOverrides;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSimulation() {
            return this.simulation;
        }

        public final void setSimulation(String simulation) {
            this.simulation = simulation;
        }

        @Override
        public final Builder simulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationAppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetStatus() {
            return this.targetStatus;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(SimulationAppTargetStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        @Override
        public DescribeAppResponse build() {
            return new DescribeAppResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SimSpaceWeaverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAppResponse> {
        public Builder description(String var1);

        public Builder domain(String var1);

        public Builder endpointInfo(SimulationAppEndpointInfo var1);

        default public Builder endpointInfo(Consumer<SimulationAppEndpointInfo.Builder> endpointInfo) {
            return this.endpointInfo((SimulationAppEndpointInfo)((SimulationAppEndpointInfo.Builder)SimulationAppEndpointInfo.builder().applyMutation(endpointInfo)).build());
        }

        public Builder launchOverrides(LaunchOverrides var1);

        default public Builder launchOverrides(Consumer<LaunchOverrides.Builder> launchOverrides) {
            return this.launchOverrides((LaunchOverrides)((LaunchOverrides.Builder)LaunchOverrides.builder().applyMutation(launchOverrides)).build());
        }

        public Builder name(String var1);

        public Builder simulation(String var1);

        public Builder status(String var1);

        public Builder status(SimulationAppStatus var1);

        public Builder targetStatus(String var1);

        public Builder targetStatus(SimulationAppTargetStatus var1);
    }
}

