/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin.internal;

import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.spi.signer.AsyncSignRequest;
import software.amazon.awssdk.http.auth.spi.signer.AsyncSignedRequest;
import software.amazon.awssdk.http.auth.spi.signer.BaseSignRequest;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.services.signin.internal.DpopHeaderGenerator;
import software.amazon.awssdk.services.signin.internal.DpopIdentity;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public class DpopSigner
implements HttpSigner<DpopIdentity> {
    public SignedRequest sign(SignRequest<? extends DpopIdentity> request) {
        return (SignedRequest)((SignedRequest.Builder)((SignedRequest.Builder)SignedRequest.builder().request(this.doSign((BaseSignRequest<?, ? extends DpopIdentity>)request))).payload((Object)request.payload().orElse(null))).build();
    }

    public CompletableFuture<AsyncSignedRequest> signAsync(AsyncSignRequest<? extends DpopIdentity> request) {
        return CompletableFuture.completedFuture((AsyncSignedRequest)((AsyncSignedRequest.Builder)((AsyncSignedRequest.Builder)AsyncSignedRequest.builder().request(this.doSign((BaseSignRequest<?, ? extends DpopIdentity>)request))).payload((Object)request.payload().orElse(null))).build());
    }

    private SdkHttpRequest doSign(BaseSignRequest<?, ? extends DpopIdentity> request) {
        return (SdkHttpRequest)((SdkHttpRequest.Builder)request.request().toBuilder()).putHeader("DPoP", this.buildDpopHeader(request)).build();
    }

    private String buildDpopHeader(BaseSignRequest<?, ? extends DpopIdentity> request) {
        SdkHttpRequest httpRequest = request.request();
        String endpoint = DpopSigner.extractRequestEndpoint(httpRequest);
        return DpopHeaderGenerator.generateDPoPProofHeader((DpopIdentity)request.identity(), endpoint, httpRequest.method().name(), Instant.now().getEpochSecond(), UUID.randomUUID().toString());
    }

    private static String extractRequestEndpoint(SdkHttpRequest httpRequest) {
        String portString = SdkHttpUtils.isUsingStandardPort((String)httpRequest.protocol(), (Integer)httpRequest.port()) ? "" : ":" + httpRequest.port();
        return httpRequest.protocol() + "://" + httpRequest.host() + portString + httpRequest.encodedPath();
    }
}

