/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.signer.model.SignedObject;
import software.amazon.awssdk.services.signer.model.SignerResponse;
import software.amazon.awssdk.services.signer.model.SigningMaterial;
import software.amazon.awssdk.services.signer.model.SigningParametersCopier;
import software.amazon.awssdk.services.signer.model.SigningPlatformOverrides;
import software.amazon.awssdk.services.signer.model.SigningStatus;
import software.amazon.awssdk.services.signer.model.Source;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSigningJobResponse
extends SignerResponse
implements ToCopyableBuilder<Builder, DescribeSigningJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::jobId)).setter(DescribeSigningJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::source)).setter(DescribeSigningJobResponse.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::signingMaterial)).setter(DescribeSigningJobResponse.setter(Builder::signingMaterial)).constructor(SigningMaterial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()}).build();
    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::platformId)).setter(DescribeSigningJobResponse.setter(Builder::platformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()}).build();
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::profileName)).setter(DescribeSigningJobResponse.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileName").build()}).build();
    private static final SdkField<SigningPlatformOverrides> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::overrides)).setter(DescribeSigningJobResponse.setter(Builder::overrides)).constructor(SigningPlatformOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()}).build();
    private static final SdkField<Map<String, String>> SIGNING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::signingParameters)).setter(DescribeSigningJobResponse.setter(Builder::signingParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::createdAt)).setter(DescribeSigningJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::completedAt)).setter(DescribeSigningJobResponse.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()}).build();
    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::requestedBy)).setter(DescribeSigningJobResponse.setter(Builder::requestedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedBy").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::statusAsString)).setter(DescribeSigningJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::statusReason)).setter(DescribeSigningJobResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<SignedObject> SIGNED_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::signedObject)).setter(DescribeSigningJobResponse.setter(Builder::signedObject)).constructor(SignedObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signedObject").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, SOURCE_FIELD, SIGNING_MATERIAL_FIELD, PLATFORM_ID_FIELD, PROFILE_NAME_FIELD, OVERRIDES_FIELD, SIGNING_PARAMETERS_FIELD, CREATED_AT_FIELD, COMPLETED_AT_FIELD, REQUESTED_BY_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, SIGNED_OBJECT_FIELD));
    private final String jobId;
    private final Source source;
    private final SigningMaterial signingMaterial;
    private final String platformId;
    private final String profileName;
    private final SigningPlatformOverrides overrides;
    private final Map<String, String> signingParameters;
    private final Instant createdAt;
    private final Instant completedAt;
    private final String requestedBy;
    private final String status;
    private final String statusReason;
    private final SignedObject signedObject;

    private DescribeSigningJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.source = builder.source;
        this.signingMaterial = builder.signingMaterial;
        this.platformId = builder.platformId;
        this.profileName = builder.profileName;
        this.overrides = builder.overrides;
        this.signingParameters = builder.signingParameters;
        this.createdAt = builder.createdAt;
        this.completedAt = builder.completedAt;
        this.requestedBy = builder.requestedBy;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.signedObject = builder.signedObject;
    }

    public String jobId() {
        return this.jobId;
    }

    public Source source() {
        return this.source;
    }

    public SigningMaterial signingMaterial() {
        return this.signingMaterial;
    }

    public String platformId() {
        return this.platformId;
    }

    public String profileName() {
        return this.profileName;
    }

    public SigningPlatformOverrides overrides() {
        return this.overrides;
    }

    public Map<String, String> signingParameters() {
        return this.signingParameters;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant completedAt() {
        return this.completedAt;
    }

    public String requestedBy() {
        return this.requestedBy;
    }

    public SigningStatus status() {
        return SigningStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public SignedObject signedObject() {
        return this.signedObject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.signedObject());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSigningJobResponse)) {
            return false;
        }
        DescribeSigningJobResponse other = (DescribeSigningJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.signingMaterial(), other.signingMaterial()) && Objects.equals(this.platformId(), other.platformId()) && Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.overrides(), other.overrides()) && Objects.equals(this.signingParameters(), other.signingParameters()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.requestedBy(), other.requestedBy()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.signedObject(), other.signedObject());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSigningJobResponse").add("JobId", (Object)this.jobId()).add("Source", (Object)this.source()).add("SigningMaterial", (Object)this.signingMaterial()).add("PlatformId", (Object)this.platformId()).add("ProfileName", (Object)this.profileName()).add("Overrides", (Object)this.overrides()).add("SigningParameters", this.signingParameters()).add("CreatedAt", (Object)this.createdAt()).add("CompletedAt", (Object)this.completedAt()).add("RequestedBy", (Object)this.requestedBy()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("SignedObject", (Object)this.signedObject()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "signingMaterial": {
                return Optional.ofNullable(clazz.cast(this.signingMaterial()));
            }
            case "platformId": {
                return Optional.ofNullable(clazz.cast(this.platformId()));
            }
            case "profileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "signingParameters": {
                return Optional.ofNullable(clazz.cast(this.signingParameters()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "completedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "requestedBy": {
                return Optional.ofNullable(clazz.cast(this.requestedBy()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "signedObject": {
                return Optional.ofNullable(clazz.cast(this.signedObject()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSigningJobResponse, T> g) {
        return obj -> g.apply((DescribeSigningJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private Source source;
        private SigningMaterial signingMaterial;
        private String platformId;
        private String profileName;
        private SigningPlatformOverrides overrides;
        private Map<String, String> signingParameters = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdAt;
        private Instant completedAt;
        private String requestedBy;
        private String status;
        private String statusReason;
        private SignedObject signedObject;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSigningJobResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.source(model.source);
            this.signingMaterial(model.signingMaterial);
            this.platformId(model.platformId);
            this.profileName(model.profileName);
            this.overrides(model.overrides);
            this.signingParameters(model.signingParameters);
            this.createdAt(model.createdAt);
            this.completedAt(model.completedAt);
            this.requestedBy(model.requestedBy);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.signedObject(model.signedObject);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return this.signingMaterial != null ? this.signingMaterial.toBuilder() : null;
        }

        @Override
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        public final String getPlatformId() {
            return this.platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        public final String getProfileName() {
            return this.profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final SigningPlatformOverrides.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        @Override
        public final Builder overrides(SigningPlatformOverrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public final void setOverrides(SigningPlatformOverrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        public final Map<String, String> getSigningParameters() {
            return this.signingParameters;
        }

        @Override
        public final Builder signingParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
            return this;
        }

        public final void setSigningParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        public final String getRequestedBy() {
            return this.requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final SignedObject.Builder getSignedObject() {
            return this.signedObject != null ? this.signedObject.toBuilder() : null;
        }

        @Override
        public final Builder signedObject(SignedObject signedObject) {
            this.signedObject = signedObject;
            return this;
        }

        public final void setSignedObject(SignedObject.BuilderImpl signedObject) {
            this.signedObject = signedObject != null ? signedObject.build() : null;
        }

        @Override
        public DescribeSigningJobResponse build() {
            return new DescribeSigningJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SignerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSigningJobResponse> {
        public Builder jobId(String var1);

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder signingMaterial(SigningMaterial var1);

        default public Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return this.signingMaterial((SigningMaterial)((SigningMaterial.Builder)SigningMaterial.builder().applyMutation(signingMaterial)).build());
        }

        public Builder platformId(String var1);

        public Builder profileName(String var1);

        public Builder overrides(SigningPlatformOverrides var1);

        default public Builder overrides(Consumer<SigningPlatformOverrides.Builder> overrides) {
            return this.overrides((SigningPlatformOverrides)((SigningPlatformOverrides.Builder)SigningPlatformOverrides.builder().applyMutation(overrides)).build());
        }

        public Builder signingParameters(Map<String, String> var1);

        public Builder createdAt(Instant var1);

        public Builder completedAt(Instant var1);

        public Builder requestedBy(String var1);

        public Builder status(String var1);

        public Builder status(SigningStatus var1);

        public Builder statusReason(String var1);

        public Builder signedObject(SignedObject var1);

        default public Builder signedObject(Consumer<SignedObject.Builder> signedObject) {
            return this.signedObject((SignedObject)((SignedObject.Builder)SignedObject.builder().applyMutation(signedObject)).build());
        }
    }
}

