/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EncryptionAlgorithm {
    RSA("RSA"),
    ECDSA("ECDSA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EncryptionAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EncryptionAlgorithm.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionAlgorithm> knownValues() {
        return Stream.of(EncryptionAlgorithm.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

