/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.signer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSigningJobResponse extends SignerResponse implements
        ToCopyableBuilder<DescribeSigningJobResponse.Builder, DescribeSigningJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(DescribeSigningJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<Source> SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(DescribeSigningJobResponse::source)).setter(setter(Builder::source)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField
            .<SigningMaterial> builder(MarshallingType.SDK_POJO).memberName("signingMaterial")
            .getter(getter(DescribeSigningJobResponse::signingMaterial)).setter(setter(Builder::signingMaterial))
            .constructor(SigningMaterial::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()).build();

    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformId").getter(getter(DescribeSigningJobResponse::platformId)).setter(setter(Builder::platformId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()).build();

    private static final SdkField<String> PLATFORM_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformDisplayName").getter(getter(DescribeSigningJobResponse::platformDisplayName))
            .setter(setter(Builder::platformDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformDisplayName").build())
            .build();

    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileName").getter(getter(DescribeSigningJobResponse::profileName))
            .setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileName").build()).build();

    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileVersion").getter(getter(DescribeSigningJobResponse::profileVersion))
            .setter(setter(Builder::profileVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersion").build()).build();

    private static final SdkField<SigningPlatformOverrides> OVERRIDES_FIELD = SdkField
            .<SigningPlatformOverrides> builder(MarshallingType.SDK_POJO).memberName("overrides")
            .getter(getter(DescribeSigningJobResponse::overrides)).setter(setter(Builder::overrides))
            .constructor(SigningPlatformOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()).build();

    private static final SdkField<Map<String, String>> SIGNING_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("signingParameters")
            .getter(getter(DescribeSigningJobResponse::signingParameters))
            .setter(setter(Builder::signingParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DescribeSigningJobResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("completedAt").getter(getter(DescribeSigningJobResponse::completedAt))
            .setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()).build();

    private static final SdkField<Instant> SIGNATURE_EXPIRES_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("signatureExpiresAt").getter(getter(DescribeSigningJobResponse::signatureExpiresAt))
            .setter(setter(Builder::signatureExpiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureExpiresAt").build())
            .build();

    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestedBy").getter(getter(DescribeSigningJobResponse::requestedBy))
            .setter(setter(Builder::requestedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedBy").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeSigningJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(DescribeSigningJobResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<SigningJobRevocationRecord> REVOCATION_RECORD_FIELD = SdkField
            .<SigningJobRevocationRecord> builder(MarshallingType.SDK_POJO).memberName("revocationRecord")
            .getter(getter(DescribeSigningJobResponse::revocationRecord)).setter(setter(Builder::revocationRecord))
            .constructor(SigningJobRevocationRecord::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revocationRecord").build()).build();

    private static final SdkField<SignedObject> SIGNED_OBJECT_FIELD = SdkField.<SignedObject> builder(MarshallingType.SDK_POJO)
            .memberName("signedObject").getter(getter(DescribeSigningJobResponse::signedObject))
            .setter(setter(Builder::signedObject)).constructor(SignedObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signedObject").build()).build();

    private static final SdkField<String> JOB_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobOwner").getter(getter(DescribeSigningJobResponse::jobOwner)).setter(setter(Builder::jobOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOwner").build()).build();

    private static final SdkField<String> JOB_INVOKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobInvoker").getter(getter(DescribeSigningJobResponse::jobInvoker)).setter(setter(Builder::jobInvoker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobInvoker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, SOURCE_FIELD,
            SIGNING_MATERIAL_FIELD, PLATFORM_ID_FIELD, PLATFORM_DISPLAY_NAME_FIELD, PROFILE_NAME_FIELD, PROFILE_VERSION_FIELD,
            OVERRIDES_FIELD, SIGNING_PARAMETERS_FIELD, CREATED_AT_FIELD, COMPLETED_AT_FIELD, SIGNATURE_EXPIRES_AT_FIELD,
            REQUESTED_BY_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, REVOCATION_RECORD_FIELD, SIGNED_OBJECT_FIELD, JOB_OWNER_FIELD,
            JOB_INVOKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobId;

    private final Source source;

    private final SigningMaterial signingMaterial;

    private final String platformId;

    private final String platformDisplayName;

    private final String profileName;

    private final String profileVersion;

    private final SigningPlatformOverrides overrides;

    private final Map<String, String> signingParameters;

    private final Instant createdAt;

    private final Instant completedAt;

    private final Instant signatureExpiresAt;

    private final String requestedBy;

    private final String status;

    private final String statusReason;

    private final SigningJobRevocationRecord revocationRecord;

    private final SignedObject signedObject;

    private final String jobOwner;

    private final String jobInvoker;

    private DescribeSigningJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.source = builder.source;
        this.signingMaterial = builder.signingMaterial;
        this.platformId = builder.platformId;
        this.platformDisplayName = builder.platformDisplayName;
        this.profileName = builder.profileName;
        this.profileVersion = builder.profileVersion;
        this.overrides = builder.overrides;
        this.signingParameters = builder.signingParameters;
        this.createdAt = builder.createdAt;
        this.completedAt = builder.completedAt;
        this.signatureExpiresAt = builder.signatureExpiresAt;
        this.requestedBy = builder.requestedBy;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.revocationRecord = builder.revocationRecord;
        this.signedObject = builder.signedObject;
        this.jobOwner = builder.jobOwner;
        this.jobInvoker = builder.jobInvoker;
    }

    /**
     * <p>
     * The ID of the signing job on output.
     * </p>
     * 
     * @return The ID of the signing job on output.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The object that contains the name of your S3 bucket or your raw code.
     * </p>
     * 
     * @return The object that contains the name of your S3 bucket or your raw code.
     */
    public final Source source() {
        return source;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of your code signing certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of your code signing certificate.
     */
    public final SigningMaterial signingMaterial() {
        return signingMaterial;
    }

    /**
     * <p>
     * The microcontroller platform to which your signed code image will be distributed.
     * </p>
     * 
     * @return The microcontroller platform to which your signed code image will be distributed.
     */
    public final String platformId() {
        return platformId;
    }

    /**
     * <p>
     * A human-readable name for the signing platform associated with the signing job.
     * </p>
     * 
     * @return A human-readable name for the signing platform associated with the signing job.
     */
    public final String platformDisplayName() {
        return platformDisplayName;
    }

    /**
     * <p>
     * The name of the profile that initiated the signing operation.
     * </p>
     * 
     * @return The name of the profile that initiated the signing operation.
     */
    public final String profileName() {
        return profileName;
    }

    /**
     * <p>
     * The version of the signing profile used to initiate the signing job.
     * </p>
     * 
     * @return The version of the signing profile used to initiate the signing job.
     */
    public final String profileVersion() {
        return profileVersion;
    }

    /**
     * <p>
     * A list of any overrides that were applied to the signing operation.
     * </p>
     * 
     * @return A list of any overrides that were applied to the signing operation.
     */
    public final SigningPlatformOverrides overrides() {
        return overrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the SigningParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSigningParameters() {
        return signingParameters != null && !(signingParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Map of user-assigned key-value pairs used during signing. These values contain any information that you specified
     * for use in your signing job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSigningParameters} method.
     * </p>
     * 
     * @return Map of user-assigned key-value pairs used during signing. These values contain any information that you
     *         specified for use in your signing job.
     */
    public final Map<String, String> signingParameters() {
        return signingParameters;
    }

    /**
     * <p>
     * Date and time that the signing job was created.
     * </p>
     * 
     * @return Date and time that the signing job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Date and time that the signing job was completed.
     * </p>
     * 
     * @return Date and time that the signing job was completed.
     */
    public final Instant completedAt() {
        return completedAt;
    }

    /**
     * <p>
     * Thr expiration timestamp for the signature generated by the signing job.
     * </p>
     * 
     * @return Thr expiration timestamp for the signature generated by the signing job.
     */
    public final Instant signatureExpiresAt() {
        return signatureExpiresAt;
    }

    /**
     * <p>
     * The IAM principal that requested the signing job.
     * </p>
     * 
     * @return The IAM principal that requested the signing job.
     */
    public final String requestedBy() {
        return requestedBy;
    }

    /**
     * <p>
     * Status of the signing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the signing job.
     * @see SigningStatus
     */
    public final SigningStatus status() {
        return SigningStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the signing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the signing job.
     * @see SigningStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * String value that contains the status reason.
     * </p>
     * 
     * @return String value that contains the status reason.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and the
     * ID of the IAM entity that revoked the signature.
     * </p>
     * 
     * @return A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp
     *         and the ID of the IAM entity that revoked the signature.
     */
    public final SigningJobRevocationRecord revocationRecord() {
        return revocationRecord;
    }

    /**
     * <p>
     * Name of the S3 bucket where the signed code image is saved by AWS Signer.
     * </p>
     * 
     * @return Name of the S3 bucket where the signed code image is saved by AWS Signer.
     */
    public final SignedObject signedObject() {
        return signedObject;
    }

    /**
     * <p>
     * The AWS account ID of the job owner.
     * </p>
     * 
     * @return The AWS account ID of the job owner.
     */
    public final String jobOwner() {
        return jobOwner;
    }

    /**
     * <p>
     * The IAM entity that initiated the signing job.
     * </p>
     * 
     * @return The IAM entity that initiated the signing job.
     */
    public final String jobInvoker() {
        return jobInvoker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(platformId());
        hashCode = 31 * hashCode + Objects.hashCode(platformDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(overrides());
        hashCode = 31 * hashCode + Objects.hashCode(hasSigningParameters() ? signingParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(signatureExpiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(requestedBy());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(revocationRecord());
        hashCode = 31 * hashCode + Objects.hashCode(signedObject());
        hashCode = 31 * hashCode + Objects.hashCode(jobOwner());
        hashCode = 31 * hashCode + Objects.hashCode(jobInvoker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSigningJobResponse)) {
            return false;
        }
        DescribeSigningJobResponse other = (DescribeSigningJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(source(), other.source())
                && Objects.equals(signingMaterial(), other.signingMaterial()) && Objects.equals(platformId(), other.platformId())
                && Objects.equals(platformDisplayName(), other.platformDisplayName())
                && Objects.equals(profileName(), other.profileName()) && Objects.equals(profileVersion(), other.profileVersion())
                && Objects.equals(overrides(), other.overrides()) && hasSigningParameters() == other.hasSigningParameters()
                && Objects.equals(signingParameters(), other.signingParameters())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(completedAt(), other.completedAt())
                && Objects.equals(signatureExpiresAt(), other.signatureExpiresAt())
                && Objects.equals(requestedBy(), other.requestedBy()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(revocationRecord(), other.revocationRecord())
                && Objects.equals(signedObject(), other.signedObject()) && Objects.equals(jobOwner(), other.jobOwner())
                && Objects.equals(jobInvoker(), other.jobInvoker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSigningJobResponse").add("JobId", jobId()).add("Source", source())
                .add("SigningMaterial", signingMaterial()).add("PlatformId", platformId())
                .add("PlatformDisplayName", platformDisplayName()).add("ProfileName", profileName())
                .add("ProfileVersion", profileVersion()).add("Overrides", overrides())
                .add("SigningParameters", hasSigningParameters() ? signingParameters() : null).add("CreatedAt", createdAt())
                .add("CompletedAt", completedAt()).add("SignatureExpiresAt", signatureExpiresAt())
                .add("RequestedBy", requestedBy()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("RevocationRecord", revocationRecord()).add("SignedObject", signedObject()).add("JobOwner", jobOwner())
                .add("JobInvoker", jobInvoker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "signingMaterial":
            return Optional.ofNullable(clazz.cast(signingMaterial()));
        case "platformId":
            return Optional.ofNullable(clazz.cast(platformId()));
        case "platformDisplayName":
            return Optional.ofNullable(clazz.cast(platformDisplayName()));
        case "profileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "profileVersion":
            return Optional.ofNullable(clazz.cast(profileVersion()));
        case "overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        case "signingParameters":
            return Optional.ofNullable(clazz.cast(signingParameters()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "completedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        case "signatureExpiresAt":
            return Optional.ofNullable(clazz.cast(signatureExpiresAt()));
        case "requestedBy":
            return Optional.ofNullable(clazz.cast(requestedBy()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "revocationRecord":
            return Optional.ofNullable(clazz.cast(revocationRecord()));
        case "signedObject":
            return Optional.ofNullable(clazz.cast(signedObject()));
        case "jobOwner":
            return Optional.ofNullable(clazz.cast(jobOwner()));
        case "jobInvoker":
            return Optional.ofNullable(clazz.cast(jobInvoker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("signingMaterial", SIGNING_MATERIAL_FIELD);
        map.put("platformId", PLATFORM_ID_FIELD);
        map.put("platformDisplayName", PLATFORM_DISPLAY_NAME_FIELD);
        map.put("profileName", PROFILE_NAME_FIELD);
        map.put("profileVersion", PROFILE_VERSION_FIELD);
        map.put("overrides", OVERRIDES_FIELD);
        map.put("signingParameters", SIGNING_PARAMETERS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("completedAt", COMPLETED_AT_FIELD);
        map.put("signatureExpiresAt", SIGNATURE_EXPIRES_AT_FIELD);
        map.put("requestedBy", REQUESTED_BY_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("revocationRecord", REVOCATION_RECORD_FIELD);
        map.put("signedObject", SIGNED_OBJECT_FIELD);
        map.put("jobOwner", JOB_OWNER_FIELD);
        map.put("jobInvoker", JOB_INVOKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSigningJobResponse, T> g) {
        return obj -> g.apply((DescribeSigningJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SignerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSigningJobResponse> {
        /**
         * <p>
         * The ID of the signing job on output.
         * </p>
         * 
         * @param jobId
         *        The ID of the signing job on output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The object that contains the name of your S3 bucket or your raw code.
         * </p>
         * 
         * @param source
         *        The object that contains the name of your S3 bucket or your raw code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(Source source);

        /**
         * <p>
         * The object that contains the name of your S3 bucket or your raw code.
         * </p>
         * This is a convenience method that creates an instance of the {@link Source.Builder} avoiding the need to
         * create one manually via {@link Source#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #source(Source)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(Source)
         */
        default Builder source(Consumer<Source.Builder> source) {
            return source(Source.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of your code signing certificate.
         * </p>
         * 
         * @param signingMaterial
         *        The Amazon Resource Name (ARN) of your code signing certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingMaterial(SigningMaterial signingMaterial);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of your code signing certificate.
         * </p>
         * This is a convenience method that creates an instance of the {@link SigningMaterial.Builder} avoiding the
         * need to create one manually via {@link SigningMaterial#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SigningMaterial.Builder#build()} is called immediately and its
         * result is passed to {@link #signingMaterial(SigningMaterial)}.
         * 
         * @param signingMaterial
         *        a consumer that will call methods on {@link SigningMaterial.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signingMaterial(SigningMaterial)
         */
        default Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return signingMaterial(SigningMaterial.builder().applyMutation(signingMaterial).build());
        }

        /**
         * <p>
         * The microcontroller platform to which your signed code image will be distributed.
         * </p>
         * 
         * @param platformId
         *        The microcontroller platform to which your signed code image will be distributed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformId(String platformId);

        /**
         * <p>
         * A human-readable name for the signing platform associated with the signing job.
         * </p>
         * 
         * @param platformDisplayName
         *        A human-readable name for the signing platform associated with the signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformDisplayName(String platformDisplayName);

        /**
         * <p>
         * The name of the profile that initiated the signing operation.
         * </p>
         * 
         * @param profileName
         *        The name of the profile that initiated the signing operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * The version of the signing profile used to initiate the signing job.
         * </p>
         * 
         * @param profileVersion
         *        The version of the signing profile used to initiate the signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileVersion(String profileVersion);

        /**
         * <p>
         * A list of any overrides that were applied to the signing operation.
         * </p>
         * 
         * @param overrides
         *        A list of any overrides that were applied to the signing operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(SigningPlatformOverrides overrides);

        /**
         * <p>
         * A list of any overrides that were applied to the signing operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link SigningPlatformOverrides.Builder}
         * avoiding the need to create one manually via {@link SigningPlatformOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SigningPlatformOverrides.Builder#build()} is called immediately
         * and its result is passed to {@link #overrides(SigningPlatformOverrides)}.
         * 
         * @param overrides
         *        a consumer that will call methods on {@link SigningPlatformOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(SigningPlatformOverrides)
         */
        default Builder overrides(Consumer<SigningPlatformOverrides.Builder> overrides) {
            return overrides(SigningPlatformOverrides.builder().applyMutation(overrides).build());
        }

        /**
         * <p>
         * Map of user-assigned key-value pairs used during signing. These values contain any information that you
         * specified for use in your signing job.
         * </p>
         * 
         * @param signingParameters
         *        Map of user-assigned key-value pairs used during signing. These values contain any information that
         *        you specified for use in your signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingParameters(Map<String, String> signingParameters);

        /**
         * <p>
         * Date and time that the signing job was created.
         * </p>
         * 
         * @param createdAt
         *        Date and time that the signing job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Date and time that the signing job was completed.
         * </p>
         * 
         * @param completedAt
         *        Date and time that the signing job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(Instant completedAt);

        /**
         * <p>
         * Thr expiration timestamp for the signature generated by the signing job.
         * </p>
         * 
         * @param signatureExpiresAt
         *        Thr expiration timestamp for the signature generated by the signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureExpiresAt(Instant signatureExpiresAt);

        /**
         * <p>
         * The IAM principal that requested the signing job.
         * </p>
         * 
         * @param requestedBy
         *        The IAM principal that requested the signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedBy(String requestedBy);

        /**
         * <p>
         * Status of the signing job.
         * </p>
         * 
         * @param status
         *        Status of the signing job.
         * @see SigningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the signing job.
         * </p>
         * 
         * @param status
         *        Status of the signing job.
         * @see SigningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningStatus
         */
        Builder status(SigningStatus status);

        /**
         * <p>
         * String value that contains the status reason.
         * </p>
         * 
         * @param statusReason
         *        String value that contains the status reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and
         * the ID of the IAM entity that revoked the signature.
         * </p>
         * 
         * @param revocationRecord
         *        A revocation record if the signature generated by the signing job has been revoked. Contains a
         *        timestamp and the ID of the IAM entity that revoked the signature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revocationRecord(SigningJobRevocationRecord revocationRecord);

        /**
         * <p>
         * A revocation record if the signature generated by the signing job has been revoked. Contains a timestamp and
         * the ID of the IAM entity that revoked the signature.
         * </p>
         * This is a convenience method that creates an instance of the {@link SigningJobRevocationRecord.Builder}
         * avoiding the need to create one manually via {@link SigningJobRevocationRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SigningJobRevocationRecord.Builder#build()} is called immediately
         * and its result is passed to {@link #revocationRecord(SigningJobRevocationRecord)}.
         * 
         * @param revocationRecord
         *        a consumer that will call methods on {@link SigningJobRevocationRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revocationRecord(SigningJobRevocationRecord)
         */
        default Builder revocationRecord(Consumer<SigningJobRevocationRecord.Builder> revocationRecord) {
            return revocationRecord(SigningJobRevocationRecord.builder().applyMutation(revocationRecord).build());
        }

        /**
         * <p>
         * Name of the S3 bucket where the signed code image is saved by AWS Signer.
         * </p>
         * 
         * @param signedObject
         *        Name of the S3 bucket where the signed code image is saved by AWS Signer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signedObject(SignedObject signedObject);

        /**
         * <p>
         * Name of the S3 bucket where the signed code image is saved by AWS Signer.
         * </p>
         * This is a convenience method that creates an instance of the {@link SignedObject.Builder} avoiding the need
         * to create one manually via {@link SignedObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SignedObject.Builder#build()} is called immediately and its
         * result is passed to {@link #signedObject(SignedObject)}.
         * 
         * @param signedObject
         *        a consumer that will call methods on {@link SignedObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signedObject(SignedObject)
         */
        default Builder signedObject(Consumer<SignedObject.Builder> signedObject) {
            return signedObject(SignedObject.builder().applyMutation(signedObject).build());
        }

        /**
         * <p>
         * The AWS account ID of the job owner.
         * </p>
         * 
         * @param jobOwner
         *        The AWS account ID of the job owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobOwner(String jobOwner);

        /**
         * <p>
         * The IAM entity that initiated the signing job.
         * </p>
         * 
         * @param jobInvoker
         *        The IAM entity that initiated the signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobInvoker(String jobInvoker);
    }

    static final class BuilderImpl extends SignerResponse.BuilderImpl implements Builder {
        private String jobId;

        private Source source;

        private SigningMaterial signingMaterial;

        private String platformId;

        private String platformDisplayName;

        private String profileName;

        private String profileVersion;

        private SigningPlatformOverrides overrides;

        private Map<String, String> signingParameters = DefaultSdkAutoConstructMap.getInstance();

        private Instant createdAt;

        private Instant completedAt;

        private Instant signatureExpiresAt;

        private String requestedBy;

        private String status;

        private String statusReason;

        private SigningJobRevocationRecord revocationRecord;

        private SignedObject signedObject;

        private String jobOwner;

        private String jobInvoker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSigningJobResponse model) {
            super(model);
            jobId(model.jobId);
            source(model.source);
            signingMaterial(model.signingMaterial);
            platformId(model.platformId);
            platformDisplayName(model.platformDisplayName);
            profileName(model.profileName);
            profileVersion(model.profileVersion);
            overrides(model.overrides);
            signingParameters(model.signingParameters);
            createdAt(model.createdAt);
            completedAt(model.completedAt);
            signatureExpiresAt(model.signatureExpiresAt);
            requestedBy(model.requestedBy);
            status(model.status);
            statusReason(model.statusReason);
            revocationRecord(model.revocationRecord);
            signedObject(model.signedObject);
            jobOwner(model.jobOwner);
            jobInvoker(model.jobInvoker);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Source.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return signingMaterial != null ? signingMaterial.toBuilder() : null;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        @Override
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final String getPlatformId() {
            return platformId;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final String getPlatformDisplayName() {
            return platformDisplayName;
        }

        public final void setPlatformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
        }

        @Override
        public final Builder platformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
            return this;
        }

        public final String getProfileName() {
            return profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getProfileVersion() {
            return profileVersion;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final SigningPlatformOverrides.Builder getOverrides() {
            return overrides != null ? overrides.toBuilder() : null;
        }

        public final void setOverrides(SigningPlatformOverrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        @Override
        public final Builder overrides(SigningPlatformOverrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public final Map<String, String> getSigningParameters() {
            if (signingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return signingParameters;
        }

        public final void setSigningParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
        }

        @Override
        public final Builder signingParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final Instant getSignatureExpiresAt() {
            return signatureExpiresAt;
        }

        public final void setSignatureExpiresAt(Instant signatureExpiresAt) {
            this.signatureExpiresAt = signatureExpiresAt;
        }

        @Override
        public final Builder signatureExpiresAt(Instant signatureExpiresAt) {
            this.signatureExpiresAt = signatureExpiresAt;
            return this;
        }

        public final String getRequestedBy() {
            return requestedBy;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final SigningJobRevocationRecord.Builder getRevocationRecord() {
            return revocationRecord != null ? revocationRecord.toBuilder() : null;
        }

        public final void setRevocationRecord(SigningJobRevocationRecord.BuilderImpl revocationRecord) {
            this.revocationRecord = revocationRecord != null ? revocationRecord.build() : null;
        }

        @Override
        public final Builder revocationRecord(SigningJobRevocationRecord revocationRecord) {
            this.revocationRecord = revocationRecord;
            return this;
        }

        public final SignedObject.Builder getSignedObject() {
            return signedObject != null ? signedObject.toBuilder() : null;
        }

        public final void setSignedObject(SignedObject.BuilderImpl signedObject) {
            this.signedObject = signedObject != null ? signedObject.build() : null;
        }

        @Override
        public final Builder signedObject(SignedObject signedObject) {
            this.signedObject = signedObject;
            return this;
        }

        public final String getJobOwner() {
            return jobOwner;
        }

        public final void setJobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
        }

        @Override
        public final Builder jobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
            return this;
        }

        public final String getJobInvoker() {
            return jobInvoker;
        }

        public final void setJobInvoker(String jobInvoker) {
            this.jobInvoker = jobInvoker;
        }

        @Override
        public final Builder jobInvoker(String jobInvoker) {
            this.jobInvoker = jobInvoker;
            return this;
        }

        @Override
        public DescribeSigningJobResponse build() {
            return new DescribeSigningJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
