/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.signer.model.SignerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddProfilePermissionRequest
extends SignerRequest
implements ToCopyableBuilder<Builder, AddProfilePermissionRequest> {
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileName").getter(AddProfilePermissionRequest.getter(AddProfilePermissionRequest::profileName)).setter(AddProfilePermissionRequest.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("profileName").build()}).build();
    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileVersion").getter(AddProfilePermissionRequest.getter(AddProfilePermissionRequest::profileVersion)).setter(AddProfilePermissionRequest.setter(Builder::profileVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersion").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(AddProfilePermissionRequest.getter(AddProfilePermissionRequest::action)).setter(AddProfilePermissionRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principal").getter(AddProfilePermissionRequest.getter(AddProfilePermissionRequest::principal)).setter(AddProfilePermissionRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(AddProfilePermissionRequest.getter(AddProfilePermissionRequest::revisionId)).setter(AddProfilePermissionRequest.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statementId").getter(AddProfilePermissionRequest.getter(AddProfilePermissionRequest::statementId)).setter(AddProfilePermissionRequest.setter(Builder::statementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_NAME_FIELD, PROFILE_VERSION_FIELD, ACTION_FIELD, PRINCIPAL_FIELD, REVISION_ID_FIELD, STATEMENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddProfilePermissionRequest.memberNameToFieldInitializer();
    private final String profileName;
    private final String profileVersion;
    private final String action;
    private final String principal;
    private final String revisionId;
    private final String statementId;

    private AddProfilePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.profileVersion = builder.profileVersion;
        this.action = builder.action;
        this.principal = builder.principal;
        this.revisionId = builder.revisionId;
        this.statementId = builder.statementId;
    }

    public final String profileName() {
        return this.profileName;
    }

    public final String profileVersion() {
        return this.profileVersion;
    }

    public final String action() {
        return this.action;
    }

    public final String principal() {
        return this.principal;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final String statementId() {
        return this.statementId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddProfilePermissionRequest)) {
            return false;
        }
        AddProfilePermissionRequest other = (AddProfilePermissionRequest)((Object)obj);
        return Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.profileVersion(), other.profileVersion()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.statementId(), other.statementId());
    }

    public final String toString() {
        return ToString.builder((String)"AddProfilePermissionRequest").add("ProfileName", (Object)this.profileName()).add("ProfileVersion", (Object)this.profileVersion()).add("Action", (Object)this.action()).add("Principal", (Object)this.principal()).add("RevisionId", (Object)this.revisionId()).add("StatementId", (Object)this.statementId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "profileVersion": {
                return Optional.ofNullable(clazz.cast(this.profileVersion()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "statementId": {
                return Optional.ofNullable(clazz.cast(this.statementId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("profileName", PROFILE_NAME_FIELD);
        map.put("profileVersion", PROFILE_VERSION_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("revisionId", REVISION_ID_FIELD);
        map.put("statementId", STATEMENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddProfilePermissionRequest, T> g) {
        return obj -> g.apply((AddProfilePermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerRequest.BuilderImpl
    implements Builder {
        private String profileName;
        private String profileVersion;
        private String action;
        private String principal;
        private String revisionId;
        private String statementId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddProfilePermissionRequest model) {
            super(model);
            this.profileName(model.profileName);
            this.profileVersion(model.profileVersion);
            this.action(model.action);
            this.principal(model.principal);
            this.revisionId(model.revisionId);
            this.statementId(model.statementId);
        }

        public final String getProfileName() {
            return this.profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getProfileVersion() {
            return this.profileVersion;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getStatementId() {
            return this.statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddProfilePermissionRequest build() {
            return new AddProfilePermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SignerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddProfilePermissionRequest> {
        public Builder profileName(String var1);

        public Builder profileVersion(String var1);

        public Builder action(String var1);

        public Builder principal(String var1);

        public Builder revisionId(String var1);

        public Builder statementId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

