/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.signer.model.ImageFormat;
import software.amazon.awssdk.services.signer.model.ImageFormatsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SigningImageFormat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SigningImageFormat> {
    private static final SdkField<List<String>> SUPPORTED_FORMATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedFormats").getter(SigningImageFormat.getter(SigningImageFormat::supportedFormatsAsStrings)).setter(SigningImageFormat.setter(Builder::supportedFormatsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedFormats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultFormat").getter(SigningImageFormat.getter(SigningImageFormat::defaultFormatAsString)).setter(SigningImageFormat.setter(Builder::defaultFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_FORMATS_FIELD, DEFAULT_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SigningImageFormat.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> supportedFormats;
    private final String defaultFormat;

    private SigningImageFormat(BuilderImpl builder) {
        this.supportedFormats = builder.supportedFormats;
        this.defaultFormat = builder.defaultFormat;
    }

    public final List<ImageFormat> supportedFormats() {
        return ImageFormatsCopier.copyStringToEnum(this.supportedFormats);
    }

    public final boolean hasSupportedFormats() {
        return this.supportedFormats != null && !(this.supportedFormats instanceof SdkAutoConstructList);
    }

    public final List<String> supportedFormatsAsStrings() {
        return this.supportedFormats;
    }

    public final ImageFormat defaultFormat() {
        return ImageFormat.fromValue(this.defaultFormat);
    }

    public final String defaultFormatAsString() {
        return this.defaultFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedFormats() ? this.supportedFormatsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningImageFormat)) {
            return false;
        }
        SigningImageFormat other = (SigningImageFormat)obj;
        return this.hasSupportedFormats() == other.hasSupportedFormats() && Objects.equals(this.supportedFormatsAsStrings(), other.supportedFormatsAsStrings()) && Objects.equals(this.defaultFormatAsString(), other.defaultFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SigningImageFormat").add("SupportedFormats", this.hasSupportedFormats() ? this.supportedFormatsAsStrings() : null).add("DefaultFormat", (Object)this.defaultFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "supportedFormats": {
                return Optional.ofNullable(clazz.cast(this.supportedFormatsAsStrings()));
            }
            case "defaultFormat": {
                return Optional.ofNullable(clazz.cast(this.defaultFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supportedFormats", SUPPORTED_FORMATS_FIELD);
        map.put("defaultFormat", DEFAULT_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SigningImageFormat, T> g) {
        return obj -> g.apply((SigningImageFormat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> supportedFormats = DefaultSdkAutoConstructList.getInstance();
        private String defaultFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningImageFormat model) {
            this.supportedFormatsWithStrings(model.supportedFormats);
            this.defaultFormat(model.defaultFormat);
        }

        public final Collection<String> getSupportedFormats() {
            if (this.supportedFormats instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedFormats;
        }

        public final void setSupportedFormats(Collection<String> supportedFormats) {
            this.supportedFormats = ImageFormatsCopier.copy(supportedFormats);
        }

        @Override
        public final Builder supportedFormatsWithStrings(Collection<String> supportedFormats) {
            this.supportedFormats = ImageFormatsCopier.copy(supportedFormats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFormatsWithStrings(String ... supportedFormats) {
            this.supportedFormatsWithStrings(Arrays.asList(supportedFormats));
            return this;
        }

        @Override
        public final Builder supportedFormats(Collection<ImageFormat> supportedFormats) {
            this.supportedFormats = ImageFormatsCopier.copyEnumToString(supportedFormats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFormats(ImageFormat ... supportedFormats) {
            this.supportedFormats(Arrays.asList(supportedFormats));
            return this;
        }

        public final String getDefaultFormat() {
            return this.defaultFormat;
        }

        public final void setDefaultFormat(String defaultFormat) {
            this.defaultFormat = defaultFormat;
        }

        @Override
        public final Builder defaultFormat(String defaultFormat) {
            this.defaultFormat = defaultFormat;
            return this;
        }

        @Override
        public final Builder defaultFormat(ImageFormat defaultFormat) {
            this.defaultFormat(defaultFormat == null ? null : defaultFormat.toString());
            return this;
        }

        public SigningImageFormat build() {
            return new SigningImageFormat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SigningImageFormat> {
        public Builder supportedFormatsWithStrings(Collection<String> var1);

        public Builder supportedFormatsWithStrings(String ... var1);

        public Builder supportedFormats(Collection<ImageFormat> var1);

        public Builder supportedFormats(ImageFormat ... var1);

        public Builder defaultFormat(String var1);

        public Builder defaultFormat(ImageFormat var1);
    }
}

