/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.signer.model.SignedObject;
import software.amazon.awssdk.services.signer.model.SignerResponse;
import software.amazon.awssdk.services.signer.model.SigningJobRevocationRecord;
import software.amazon.awssdk.services.signer.model.SigningMaterial;
import software.amazon.awssdk.services.signer.model.SigningParametersCopier;
import software.amazon.awssdk.services.signer.model.SigningPlatformOverrides;
import software.amazon.awssdk.services.signer.model.SigningStatus;
import software.amazon.awssdk.services.signer.model.Source;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSigningJobResponse
extends SignerResponse
implements ToCopyableBuilder<Builder, DescribeSigningJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::jobId)).setter(DescribeSigningJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::source)).setter(DescribeSigningJobResponse.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<SigningMaterial> SIGNING_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signingMaterial").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::signingMaterial)).setter(DescribeSigningJobResponse.setter(Builder::signingMaterial)).constructor(SigningMaterial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingMaterial").build()}).build();
    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformId").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::platformId)).setter(DescribeSigningJobResponse.setter(Builder::platformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformId").build()}).build();
    private static final SdkField<String> PLATFORM_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformDisplayName").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::platformDisplayName)).setter(DescribeSigningJobResponse.setter(Builder::platformDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformDisplayName").build()}).build();
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileName").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::profileName)).setter(DescribeSigningJobResponse.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileName").build()}).build();
    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileVersion").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::profileVersion)).setter(DescribeSigningJobResponse.setter(Builder::profileVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileVersion").build()}).build();
    private static final SdkField<SigningPlatformOverrides> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("overrides").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::overrides)).setter(DescribeSigningJobResponse.setter(Builder::overrides)).constructor(SigningPlatformOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()}).build();
    private static final SdkField<Map<String, String>> SIGNING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("signingParameters").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::signingParameters)).setter(DescribeSigningJobResponse.setter(Builder::signingParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::createdAt)).setter(DescribeSigningJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedAt").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::completedAt)).setter(DescribeSigningJobResponse.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()}).build();
    private static final SdkField<Instant> SIGNATURE_EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("signatureExpiresAt").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::signatureExpiresAt)).setter(DescribeSigningJobResponse.setter(Builder::signatureExpiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureExpiresAt").build()}).build();
    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestedBy").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::requestedBy)).setter(DescribeSigningJobResponse.setter(Builder::requestedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedBy").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::statusAsString)).setter(DescribeSigningJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::statusReason)).setter(DescribeSigningJobResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<SigningJobRevocationRecord> REVOCATION_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("revocationRecord").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::revocationRecord)).setter(DescribeSigningJobResponse.setter(Builder::revocationRecord)).constructor(SigningJobRevocationRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revocationRecord").build()}).build();
    private static final SdkField<SignedObject> SIGNED_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signedObject").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::signedObject)).setter(DescribeSigningJobResponse.setter(Builder::signedObject)).constructor(SignedObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signedObject").build()}).build();
    private static final SdkField<String> JOB_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobOwner").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::jobOwner)).setter(DescribeSigningJobResponse.setter(Builder::jobOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobOwner").build()}).build();
    private static final SdkField<String> JOB_INVOKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobInvoker").getter(DescribeSigningJobResponse.getter(DescribeSigningJobResponse::jobInvoker)).setter(DescribeSigningJobResponse.setter(Builder::jobInvoker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobInvoker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, SOURCE_FIELD, SIGNING_MATERIAL_FIELD, PLATFORM_ID_FIELD, PLATFORM_DISPLAY_NAME_FIELD, PROFILE_NAME_FIELD, PROFILE_VERSION_FIELD, OVERRIDES_FIELD, SIGNING_PARAMETERS_FIELD, CREATED_AT_FIELD, COMPLETED_AT_FIELD, SIGNATURE_EXPIRES_AT_FIELD, REQUESTED_BY_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, REVOCATION_RECORD_FIELD, SIGNED_OBJECT_FIELD, JOB_OWNER_FIELD, JOB_INVOKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("jobId", JOB_ID_FIELD);
            this.put("source", SOURCE_FIELD);
            this.put("signingMaterial", SIGNING_MATERIAL_FIELD);
            this.put("platformId", PLATFORM_ID_FIELD);
            this.put("platformDisplayName", PLATFORM_DISPLAY_NAME_FIELD);
            this.put("profileName", PROFILE_NAME_FIELD);
            this.put("profileVersion", PROFILE_VERSION_FIELD);
            this.put("overrides", OVERRIDES_FIELD);
            this.put("signingParameters", SIGNING_PARAMETERS_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("completedAt", COMPLETED_AT_FIELD);
            this.put("signatureExpiresAt", SIGNATURE_EXPIRES_AT_FIELD);
            this.put("requestedBy", REQUESTED_BY_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("statusReason", STATUS_REASON_FIELD);
            this.put("revocationRecord", REVOCATION_RECORD_FIELD);
            this.put("signedObject", SIGNED_OBJECT_FIELD);
            this.put("jobOwner", JOB_OWNER_FIELD);
            this.put("jobInvoker", JOB_INVOKER_FIELD);
        }
    });
    private final String jobId;
    private final Source source;
    private final SigningMaterial signingMaterial;
    private final String platformId;
    private final String platformDisplayName;
    private final String profileName;
    private final String profileVersion;
    private final SigningPlatformOverrides overrides;
    private final Map<String, String> signingParameters;
    private final Instant createdAt;
    private final Instant completedAt;
    private final Instant signatureExpiresAt;
    private final String requestedBy;
    private final String status;
    private final String statusReason;
    private final SigningJobRevocationRecord revocationRecord;
    private final SignedObject signedObject;
    private final String jobOwner;
    private final String jobInvoker;

    private DescribeSigningJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.source = builder.source;
        this.signingMaterial = builder.signingMaterial;
        this.platformId = builder.platformId;
        this.platformDisplayName = builder.platformDisplayName;
        this.profileName = builder.profileName;
        this.profileVersion = builder.profileVersion;
        this.overrides = builder.overrides;
        this.signingParameters = builder.signingParameters;
        this.createdAt = builder.createdAt;
        this.completedAt = builder.completedAt;
        this.signatureExpiresAt = builder.signatureExpiresAt;
        this.requestedBy = builder.requestedBy;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.revocationRecord = builder.revocationRecord;
        this.signedObject = builder.signedObject;
        this.jobOwner = builder.jobOwner;
        this.jobInvoker = builder.jobInvoker;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final Source source() {
        return this.source;
    }

    public final SigningMaterial signingMaterial() {
        return this.signingMaterial;
    }

    public final String platformId() {
        return this.platformId;
    }

    public final String platformDisplayName() {
        return this.platformDisplayName;
    }

    public final String profileName() {
        return this.profileName;
    }

    public final String profileVersion() {
        return this.profileVersion;
    }

    public final SigningPlatformOverrides overrides() {
        return this.overrides;
    }

    public final boolean hasSigningParameters() {
        return this.signingParameters != null && !(this.signingParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> signingParameters() {
        return this.signingParameters;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public final Instant signatureExpiresAt() {
        return this.signatureExpiresAt;
    }

    public final String requestedBy() {
        return this.requestedBy;
    }

    public final SigningStatus status() {
        return SigningStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final SigningJobRevocationRecord revocationRecord() {
        return this.revocationRecord;
    }

    public final SignedObject signedObject() {
        return this.signedObject;
    }

    public final String jobOwner() {
        return this.jobOwner;
    }

    public final String jobInvoker() {
        return this.jobInvoker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSigningParameters() ? this.signingParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureExpiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationRecord());
        hashCode = 31 * hashCode + Objects.hashCode(this.signedObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobInvoker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSigningJobResponse)) {
            return false;
        }
        DescribeSigningJobResponse other = (DescribeSigningJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.signingMaterial(), other.signingMaterial()) && Objects.equals(this.platformId(), other.platformId()) && Objects.equals(this.platformDisplayName(), other.platformDisplayName()) && Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.profileVersion(), other.profileVersion()) && Objects.equals(this.overrides(), other.overrides()) && this.hasSigningParameters() == other.hasSigningParameters() && Objects.equals(this.signingParameters(), other.signingParameters()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.signatureExpiresAt(), other.signatureExpiresAt()) && Objects.equals(this.requestedBy(), other.requestedBy()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.revocationRecord(), other.revocationRecord()) && Objects.equals(this.signedObject(), other.signedObject()) && Objects.equals(this.jobOwner(), other.jobOwner()) && Objects.equals(this.jobInvoker(), other.jobInvoker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSigningJobResponse").add("JobId", (Object)this.jobId()).add("Source", (Object)this.source()).add("SigningMaterial", (Object)this.signingMaterial()).add("PlatformId", (Object)this.platformId()).add("PlatformDisplayName", (Object)this.platformDisplayName()).add("ProfileName", (Object)this.profileName()).add("ProfileVersion", (Object)this.profileVersion()).add("Overrides", (Object)this.overrides()).add("SigningParameters", this.hasSigningParameters() ? this.signingParameters() : null).add("CreatedAt", (Object)this.createdAt()).add("CompletedAt", (Object)this.completedAt()).add("SignatureExpiresAt", (Object)this.signatureExpiresAt()).add("RequestedBy", (Object)this.requestedBy()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("RevocationRecord", (Object)this.revocationRecord()).add("SignedObject", (Object)this.signedObject()).add("JobOwner", (Object)this.jobOwner()).add("JobInvoker", (Object)this.jobInvoker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "signingMaterial": {
                return Optional.ofNullable(clazz.cast(this.signingMaterial()));
            }
            case "platformId": {
                return Optional.ofNullable(clazz.cast(this.platformId()));
            }
            case "platformDisplayName": {
                return Optional.ofNullable(clazz.cast(this.platformDisplayName()));
            }
            case "profileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "profileVersion": {
                return Optional.ofNullable(clazz.cast(this.profileVersion()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "signingParameters": {
                return Optional.ofNullable(clazz.cast(this.signingParameters()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "completedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "signatureExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.signatureExpiresAt()));
            }
            case "requestedBy": {
                return Optional.ofNullable(clazz.cast(this.requestedBy()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "revocationRecord": {
                return Optional.ofNullable(clazz.cast(this.revocationRecord()));
            }
            case "signedObject": {
                return Optional.ofNullable(clazz.cast(this.signedObject()));
            }
            case "jobOwner": {
                return Optional.ofNullable(clazz.cast(this.jobOwner()));
            }
            case "jobInvoker": {
                return Optional.ofNullable(clazz.cast(this.jobInvoker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSigningJobResponse, T> g) {
        return obj -> g.apply((DescribeSigningJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private Source source;
        private SigningMaterial signingMaterial;
        private String platformId;
        private String platformDisplayName;
        private String profileName;
        private String profileVersion;
        private SigningPlatformOverrides overrides;
        private Map<String, String> signingParameters = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdAt;
        private Instant completedAt;
        private Instant signatureExpiresAt;
        private String requestedBy;
        private String status;
        private String statusReason;
        private SigningJobRevocationRecord revocationRecord;
        private SignedObject signedObject;
        private String jobOwner;
        private String jobInvoker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSigningJobResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.source(model.source);
            this.signingMaterial(model.signingMaterial);
            this.platformId(model.platformId);
            this.platformDisplayName(model.platformDisplayName);
            this.profileName(model.profileName);
            this.profileVersion(model.profileVersion);
            this.overrides(model.overrides);
            this.signingParameters(model.signingParameters);
            this.createdAt(model.createdAt);
            this.completedAt(model.completedAt);
            this.signatureExpiresAt(model.signatureExpiresAt);
            this.requestedBy(model.requestedBy);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.revocationRecord(model.revocationRecord);
            this.signedObject(model.signedObject);
            this.jobOwner(model.jobOwner);
            this.jobInvoker(model.jobInvoker);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final SigningMaterial.Builder getSigningMaterial() {
            return this.signingMaterial != null ? this.signingMaterial.toBuilder() : null;
        }

        public final void setSigningMaterial(SigningMaterial.BuilderImpl signingMaterial) {
            this.signingMaterial = signingMaterial != null ? signingMaterial.build() : null;
        }

        @Override
        public final Builder signingMaterial(SigningMaterial signingMaterial) {
            this.signingMaterial = signingMaterial;
            return this;
        }

        public final String getPlatformId() {
            return this.platformId;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final String getPlatformDisplayName() {
            return this.platformDisplayName;
        }

        public final void setPlatformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
        }

        @Override
        public final Builder platformDisplayName(String platformDisplayName) {
            this.platformDisplayName = platformDisplayName;
            return this;
        }

        public final String getProfileName() {
            return this.profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getProfileVersion() {
            return this.profileVersion;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        public final SigningPlatformOverrides.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        public final void setOverrides(SigningPlatformOverrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        @Override
        public final Builder overrides(SigningPlatformOverrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public final Map<String, String> getSigningParameters() {
            if (this.signingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.signingParameters;
        }

        public final void setSigningParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
        }

        @Override
        public final Builder signingParameters(Map<String, String> signingParameters) {
            this.signingParameters = SigningParametersCopier.copy(signingParameters);
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final Instant getSignatureExpiresAt() {
            return this.signatureExpiresAt;
        }

        public final void setSignatureExpiresAt(Instant signatureExpiresAt) {
            this.signatureExpiresAt = signatureExpiresAt;
        }

        @Override
        public final Builder signatureExpiresAt(Instant signatureExpiresAt) {
            this.signatureExpiresAt = signatureExpiresAt;
            return this;
        }

        public final String getRequestedBy() {
            return this.requestedBy;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final SigningJobRevocationRecord.Builder getRevocationRecord() {
            return this.revocationRecord != null ? this.revocationRecord.toBuilder() : null;
        }

        public final void setRevocationRecord(SigningJobRevocationRecord.BuilderImpl revocationRecord) {
            this.revocationRecord = revocationRecord != null ? revocationRecord.build() : null;
        }

        @Override
        public final Builder revocationRecord(SigningJobRevocationRecord revocationRecord) {
            this.revocationRecord = revocationRecord;
            return this;
        }

        public final SignedObject.Builder getSignedObject() {
            return this.signedObject != null ? this.signedObject.toBuilder() : null;
        }

        public final void setSignedObject(SignedObject.BuilderImpl signedObject) {
            this.signedObject = signedObject != null ? signedObject.build() : null;
        }

        @Override
        public final Builder signedObject(SignedObject signedObject) {
            this.signedObject = signedObject;
            return this;
        }

        public final String getJobOwner() {
            return this.jobOwner;
        }

        public final void setJobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
        }

        @Override
        public final Builder jobOwner(String jobOwner) {
            this.jobOwner = jobOwner;
            return this;
        }

        public final String getJobInvoker() {
            return this.jobInvoker;
        }

        public final void setJobInvoker(String jobInvoker) {
            this.jobInvoker = jobInvoker;
        }

        @Override
        public final Builder jobInvoker(String jobInvoker) {
            this.jobInvoker = jobInvoker;
            return this;
        }

        @Override
        public DescribeSigningJobResponse build() {
            return new DescribeSigningJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SignerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSigningJobResponse> {
        public Builder jobId(String var1);

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder signingMaterial(SigningMaterial var1);

        default public Builder signingMaterial(Consumer<SigningMaterial.Builder> signingMaterial) {
            return this.signingMaterial((SigningMaterial)((SigningMaterial.Builder)SigningMaterial.builder().applyMutation(signingMaterial)).build());
        }

        public Builder platformId(String var1);

        public Builder platformDisplayName(String var1);

        public Builder profileName(String var1);

        public Builder profileVersion(String var1);

        public Builder overrides(SigningPlatformOverrides var1);

        default public Builder overrides(Consumer<SigningPlatformOverrides.Builder> overrides) {
            return this.overrides((SigningPlatformOverrides)((SigningPlatformOverrides.Builder)SigningPlatformOverrides.builder().applyMutation(overrides)).build());
        }

        public Builder signingParameters(Map<String, String> var1);

        public Builder createdAt(Instant var1);

        public Builder completedAt(Instant var1);

        public Builder signatureExpiresAt(Instant var1);

        public Builder requestedBy(String var1);

        public Builder status(String var1);

        public Builder status(SigningStatus var1);

        public Builder statusReason(String var1);

        public Builder revocationRecord(SigningJobRevocationRecord var1);

        default public Builder revocationRecord(Consumer<SigningJobRevocationRecord.Builder> revocationRecord) {
            return this.revocationRecord((SigningJobRevocationRecord)((SigningJobRevocationRecord.Builder)SigningJobRevocationRecord.builder().applyMutation(revocationRecord)).build());
        }

        public Builder signedObject(SignedObject var1);

        default public Builder signedObject(Consumer<SignedObject.Builder> signedObject) {
            return this.signedObject((SignedObject)((SignedObject.Builder)SignedObject.builder().applyMutation(signedObject)).build());
        }

        public Builder jobOwner(String var1);

        public Builder jobInvoker(String var1);
    }
}

